<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('manuals', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->text('descripcion')->nullable();
            $table->boolean('estado')->default(true);
            $table->timestamps();
        });

        Schema::create('manual_sections', function (Blueprint $table) {
            $table->id();
            $table->foreignId('manual_id')->constrained('manuals')->cascadeOnDelete();
            $table->foreignId('parent_id')->nullable()->constrained('manual_sections');
            $table->string('titulo');
            $table->integer('orden')->default(0);
            $table->timestamps();
        });

        Schema::create('manual_contents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('section_id')->constrained('manual_sections')->cascadeOnDelete();
            $table->string('titulo');
            $table->longText('contenido');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('manual_contents');
        Schema::dropIfExists('manual_sections');
        Schema::dropIfExists('manuals');
    }
};
