<?php

use Illuminate\Support\Facades\Route;
use Sedem\ManualUsuario\Http\Controllers\ManualController;
use Sedem\ManualUsuario\Http\Controllers\Admin\UploadController;
use Sedem\ManualUsuario\Http\Controllers\Admin\ManualAdminController;
use Sedem\ManualUsuario\Http\Controllers\Admin\ManualSectionAdminController;
use Sedem\ManualUsuario\Http\Controllers\Admin\ManualContentAdminController;

/*
|--------------------------------------------------------------------------
| Rutas FRONTEND – Manual de Usuario
|--------------------------------------------------------------------------
| Accesibles por usuarios finales
*/

Route::middleware(config('manualusuario.middleware', ['web']))
    ->prefix(config('manualusuario.route_prefix', 'manual'))
    ->as('manual.')
    ->group(function () {

        Route::get('/', [ManualController::class, 'index'])
            ->name('index');

        Route::get('/section/{section}', [ManualController::class, 'show'])
            ->name('section.show');

        Route::get('/manual/{manual}/pdf', [ManualController::class, 'exportPdf'])
            ->name('pdf');

    });

/*
|--------------------------------------------------------------------------
| Rutas ADMIN – Gestión del Manual
|--------------------------------------------------------------------------
| Protegidas por auth + permisos
*/

Route::middleware(['web', 'auth', 'can:manage manuals'])
    ->prefix('admin/manual')
    ->as('admin.manual.')
    ->group(function () {

        // Subida de archivos (imágenes, PDFs, etc.)
        Route::post('/upload', [UploadController::class, 'upload'])
            ->name('upload');

        // CRUD Manuales
        Route::resource('manuals', ManualAdminController::class);

        // CRUD Secciones
        Route::resource('sections', ManualSectionAdminController::class);

        // CRUD Contenidos
        Route::resource('contents', ManualContentAdminController::class);

    });

