<?php

namespace Sedem\ManualUsuario\Console;

use Illuminate\Console\Command;

class InstallManualCommand extends Command
{
    protected $signature = 'manual:install {--force : Sobrescribir archivos existentes}';

    protected $description = 'Instala el módulo de Manual de Usuario';

    public function handle()
    {
        $this->info('📘 Instalando Manual de Usuario...');

        $this->publish('manualusuario-config');
        $this->publish('manualusuario-views');
        $this->publish('manualusuario-migrations');

        $this->info('✅ Manual de Usuario instalado correctamente');
        $this->warn('👉 Ejecuta: php artisan migrate');

        return Command::SUCCESS;
    }

    protected function publish(string $tag)
    {
        $params = [
            '--tag' => $tag,
        ];

        if ($this->option('force')) {
            $params['--force'] = true;
        }

        $this->callSilent('vendor:publish', $params);
        $this->line("✔ Publicado: {$tag}");
    }
}
