<?php

namespace Sedem\ManualUsuario\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Sedem\ManualUsuario\Models\Manual;
use Illuminate\Http\Request;

class ManualAdminController extends Controller
{
    public function index()
    {
        $manuals = Manual::all();
        return view('manualusuario::admin.manuals.index', compact('manuals'));
    }

    public function create()
    {
        return view('manualusuario::admin.manuals.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'descripcion' => 'nullable|string'
        ]);
        Manual::create($request->all());
        return redirect()->route('manuals.index')->with('success','Manual creado correctamente');
    }

    public function edit(Manual $manual)
    {
        return view('manualusuario::admin.manuals.edit', compact('manual'));
    }

    public function update(Request $request, Manual $manual)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
        ]);
        $manual->update($request->all());
        return redirect()->route('manuals.index')->with('success','Manual actualizado');
    }

    public function destroy(Manual $manual)
    {
        $manual->delete();
        return redirect()->route('manuals.index')->with('success','Manual eliminado');
    }
}
