<?php

namespace Sedem\ManualUsuario\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Sedem\ManualUsuario\Models\ManualContent;
use Sedem\ManualUsuario\Models\ManualSection;

class ManualContentAdminController extends Controller
{
    public function index()
    {
        $contents = ManualContent::all();
        return view('manualusuario::admin.contents.index', compact('contents'));
    }

    public function create()
    {
        $sections = ManualSection::all();
        $content = new ManualContent();
        return view('manualusuario::admin.contents.create',compact('sections','content'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'titulo' => 'required|string|max:255',
            'contenido' => 'required',
        ]);
        ManualContent::create($request->all());
        return redirect()->route('admin.manual.sections.index')->with('success','Manual creado correctamente');
    }

    public function edit(ManualContent $content)
    {
        $sections = ManualSection::all();
        return view('manualusuario::admin.contents.edit', compact('content','sections'));
    }

    public function update(Request $request, ManualContent $content)
    {
        $request->validate([
            'titulo' => 'required|string|max:255',
            'contenido' => 'required',
        ]);
        $content->update($request->all());
        return redirect()->route('admin.manual.contents.index')->with('success','Manual actualizado');
    }

    public function destroy(ManualContent $content)
    {
        $content->delete();
        return redirect()->route('admin.manual.contents.index')->with('success','Manual eliminado');
    }
}
