<?php

namespace Sedem\ManualUsuario\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class UploadController extends Controller
{
    public function upload(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'upload' => 'required|image|mimes:jpeg,jpg,png,gif,svg|max:5120'
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 422);
        }

        if (!$request->hasFile('upload')) {
            return response()->json(['error' => 'No file uploaded'], 400);
        }

        $file = $request->file('upload');
        $path = $file->move(public_path('uploads/manual'), $file->getClientOriginalName()); // storage/app/public/manual
        // Asegúrate de ejecutar: php artisan storage:link
        $url = asset('uploads/manual/' . $file->getClientOriginalName());

        return response()->json(['url' => $url], 200);
    }
}
