<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Http\Requests\RoleRequest;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use RealRashid\SweetAlert\Facades\Alert;
use Spatie\Permission\Models\Permission;

class RoleController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $roles=Role::where('id','>',1)->get();
        return view('admin.roles.index',compact('roles'));
    }

    public function create()
    {
        $permissions=Permission::get();
        $grupos=Permission::select('grupo')->orderBy('grupo','asc')->distinct()->get();
        $role= new Role();
        return view('admin.roles.create',compact('permissions','role','grupos'));
    }
     public function store(RoleRequest $request)
    {
        $permissions = $request->get('permissions', []);
        
        $role=Role::create(['name'=>$request->name,'descripcion'=>$request->descripcion]);
        $permissions = $request->get('permissions', []);
        // Verifica que no esté vacío y que contenga valores válidos
        $validPermissions = Permission::whereIn('id', $permissions)->pluck('name')->toArray();

        //actualice los permisos
        $role->syncPermissions($validPermissions);
        
        Alert::success('Rol registrado correctamente!');
        return redirect()->route('roles.index');

    }

    public function show(Role $role)
    {
        $permissions=$role->permissions;
        $grupos=Permission::select('grupo')->orderBy('grupo','asc')->distinct()->get();
        // Agregar conteo de permisos por grupo
        $conteoPermisosPorGrupo = Permission::select('grupo', DB::raw('count(*) as total'))
        ->groupBy('grupo')
        ->pluck('total', 'grupo');
        return view('admin.roles.show',compact('role','permissions','grupos','conteoPermisosPorGrupo'));
    }

    public function edit(Role $role)
    {
        $permissions=Permission::get();
        $grupos=Permission::select('grupo')->orderBy('grupo','asc')->distinct()->get();
        return view('admin.roles.edit',compact('role','permissions','grupos'));
    }
    public function update(RoleRequest $request, Role $role)
    {
        //actualice el rol
        $role->update($request->all());

        //actualice los permisos
        $role->permissions()->sync($request->get('permissions'));

        Alert::success('Rol actualizado correctamente!');
        return redirect()->route('roles.index');
    }

    public function destroy(Role $role)
    {
        $role->delete();
        Alert::success('Rol eliminado correctamente!');
        return redirect()->route('roles.index');
    }
}
