<?php

namespace App\Livewire\Procesos;

use App\Models\User;
use App\Models\Proceso;
use Livewire\Component;
use App\Models\Parametro;
use Livewire\WithPagination;

class ListadoProcesosContratacionComponent extends Component
{
    use WithPagination;
    
    public $search = '';
    public $searchObjetoContratacion = '';
    public $filtroEntidad = null;
    public $filtroAsignado = null;
    public $filtroEstado = null;
    
    public $sortField = 'fecha_ingreso';
    public $sortDirection = 'desc';
    public $perPage = 10;
    public $selectedContrato = null;
    public $showModal = false;

    protected $paginationTheme = 'bootstrap';

    protected $listeners = ['refrescarTabla' => '$refresh'];
    
    protected $updatesQueryString = ['search', 'searchObjetoContratacion', 'filtroEntidad', 'filtroAsignado', 'filtroEstado'];

    // IMPORTANTE: Configurar queryString con las claves correctas
    protected $queryString = [
        'search' => ['except' => '', 'as' => 'buscar'],
        'searchObjetoContratacion' => ['except' => '', 'as' => 'objeto'],
        'filtroEntidad' => ['except' => null, 'as' => 'entidad'],
        'filtroAsignado' => ['except' => null, 'as' => 'asignado'],
        'filtroEstado' => ['except' => null, 'as' => 'estado'],
        'page' => ['except' => 1],
    ];
    
    public function mount()
    {
        // Inicializar valores desde la URL si existen
        $this->search = request()->get('buscar', '');
        $this->searchObjetoContratacion = request()->get('objeto', '');
        $this->filtroEntidad = request()->get('entidad');
        $this->filtroAsignado = request()->get('asignado');
        $this->filtroEstado = request()->get('estado');
        
        // Debug para verificar valores
        logger('Parámetros iniciales:', [
            'search' => $this->search,
            'searchObjetoContratacion' => $this->searchObjetoContratacion,
            'filtroEntidad' => $this->filtroEntidad,
            'filtroAsignado' => $this->filtroAsignado,
            'filtroEstado' => $this->filtroEstado,
            'url' => request()->fullUrl()
        ]);
    }
    
    public function updatingSearch()
    {
        $this->resetPage(); 
    }

    public function updatingSearchObjetoContratacion()
    {
        $this->resetPage();
    }

    public function updatingFiltroEntidad()
    {
        $this->resetPage();
    }

    public function updatingFiltroAsignado()
    {
        $this->resetPage();
    }

    public function updatingFiltroEstado()
    {
        $this->resetPage();
    }

    public function resetFiltros()
    {
        $this->reset([
            'search',
            'searchObjetoContratacion',
            'filtroEntidad',
            'filtroAsignado',
            'filtroEstado',
        ]);
        $this->resetPage();
        
        // Redirigir para limpiar la URL
        //return redirect()->to(request()->url());
    }

    public function render()
    {
        $contratos = Proceso::with(['ultimaAsignacion', 'ultimoSeguimiento', 'entidad'])
            ->when($this->search, fn($q) =>
                $q->where('nuri_informe', 'like', "%{$this->search}%") 
                ->orWhere('codigo', 'like', "%{$this->search}%")
            )
            ->when($this->searchObjetoContratacion, fn($q) =>
                $q->where('objeto_contratacion', 'like', "%{$this->searchObjetoContratacion}%")
            )
            ->when($this->filtroEntidad, fn($q) =>
                $q->where('entidad_id', $this->filtroEntidad)
            )
            ->when($this->filtroAsignado, fn($q) =>
                $q->whereHas('ultimaAsignacion', fn($q2) =>
                    $q2->where('responsable_id', $this->filtroAsignado)
                )
            )
            ->when($this->filtroEstado, fn($q) =>
                $q->whereHas('ultimoSeguimiento', fn($q2) =>
                    $q2->where('estado_id', $this->filtroEstado)
                )
            )
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate($this->perPage);

        return view('livewire.procesos.listado-procesos-contratacion-component', [
            'contratos' => $contratos,
            'entidades' => Parametro::where('tipo', 'empresa')->get(),
            'asignados' => User::all(),
            'estados' => Parametro::where('tipo', 'estado')->get(),
        ]);
    }

}
