<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('asignacions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('proceso_id');
            $table->unsignedBigInteger('responsable_id');
            $table->date('fecha_asignacion');
            $table->string('observacion')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('proceso_id')->references('id')->on('procesos');
            $table->foreign('responsable_id')->references('id')->on('users');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('asignacions');
    }
};
