<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('proceso_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('proceso_id');
            $table->string('nombre')->nullable();
            $table->decimal('monto', 10, 2)->nullable();
            $table->string('unidad_medida');
            $table->integer('tiempo_entrega')->comment('número de días, si es mayor a 15 días se requiere adjuntar garantía de entrega');
            $table->string('forma_entrega')->nullable();
            $table->string('lugar_entrega');
            $table->string('forma_pago');
            $table->string('garantia_entrega')->nullable()->comment('Llenado obligatorio si el tiempo de entrega es mayor a 15 días');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('proceso_id')->references('id')->on('procesos');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('proceso_items');
    }
};
