    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $('#form-nueva-empresa').off('submit').on('submit', function (e) {
        e.preventDefault();
        let form = $(this);
        let formData = form.serialize();
        $.ajax({
            url: baseUrl + '/empresas/ajax',
            type: 'POST',
            data: formData,
            dataType: 'JSON',
            success: function (response) {
                if (response.success) {
                    $('#modal-empresa').modal('hide');
                    actualizarSelectEmpresas(response.empresa.id);
                }
            },
            error: function (xhr) {
                if (xhr.status === 422) {
                    let errores = xhr.responseJSON.errors;
                    let listaErrores = '';

                    $.each(errores, function (campo, mensajes) {
                        mensajes.forEach(function (mensaje) {
                            listaErrores += `<li>${mensaje}</li>`;
                        });
                    });

                    $('#errores-empresa').removeClass('d-none').find('ul').html(listaErrores);
                } else {
                    alert('Error inesperado al guardar la empresa');
                }
            }
        });
    });

    function actualizarSelectEmpresas(idSeleccionado = null) {
        $.get(baseUrl + '/empresas_select', function (data) {
            let selectEmpresa = $('#empresa_adjudicada_id');
            selectEmpresa.empty();
            selectEmpresa.append('<option value="">Seleccione</option>');
            data.forEach(function (empresa) {
                selectEmpresa.append(
                    `<option value="${empresa.id}" ${empresa.id == idSeleccionado ? 'selected' : ''}>${empresa.nombre}</option>`
                );
            });
            let selectEmpresaContratada = $('#empresa_contratada_id');
            selectEmpresaContratada.empty();
            selectEmpresaContratada.append('<option value="">Seleccione</option>');
            data.forEach(function (empresa) {
                selectEmpresaContratada.append(
                    `<option value="${empresa.id}" ${empresa.id == idSeleccionado ? 'selected' : ''}>${empresa.nombre}</option>`
                );
            });
        });
    }
    $('#modal-empresa').on('hidden.bs.modal', function () {
        $('#errores-empresa').addClass('d-none').find('ul').html('');
        $('#form-nueva-empresa')[0].reset(); // limpia los campos si deseas
    });
