﻿/*!
 * Chart.js
 * http://chartjs.org/
 * Version: {{ version }}
 *
 * Copyright 2015 Nick Downie
 * Released under the MIT license
 * https://github.com/nnnick/Chart.js/blob/master/LICENSE.md
 */(function(){"use strict";var e=this,t=e.Chart,n=function(e){var t=this;this.canvas=e.canvas,this.ctx=e;var n=function(e,t){return e["offset"+t]?e["offset"+t]:document.defaultView.getComputedStyle(e).getPropertyValue(t)},i=this.width=n(e.canvas,"Width"),s=this.height=n(e.canvas,"Height");e.canvas.width=i,e.canvas.height=s;var i=this.width=e.canvas.width,s=this.height=e.canvas.height;return this.aspectRatio=this.width/this.height,r.retinaScale(this),this};n.defaults={global:{animation:!0,animationSteps:60,animationEasing:"easeOutQuart",showScale:!0,scaleOverride:!1,scaleSteps:null,scaleStepWidth:null,scaleStartValue:null,scaleLineColor:"rgba(0,0,0,.1)",scaleLineWidth:1,scaleShowLabels:!0,scaleLabel:"<%=value%>",scaleIntegersOnly:!0,scaleBeginAtZero:!1,scaleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",scaleFontSize:12,scaleFontStyle:"normal",scaleFontColor:"#666",responsive:!1,maintainAspectRatio:!0,showTooltips:!0,customTooltips:!1,tooltipEvents:["mousemove","touchstart","touchmove","mouseout"],tooltipFillColor:"rgba(0,0,0,0.8)",tooltipFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipFontSize:14,tooltipFontStyle:"normal",tooltipFontColor:"#fff",tooltipTitleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipTitleFontSize:14,tooltipTitleFontStyle:"bold",tooltipTitleFontColor:"#fff",tooltipYPadding:6,tooltipXPadding:6,tooltipCaretSize:8,tooltipCornerRadius:6,tooltipXOffset:10,tooltipTemplate:"<%if (label){%><%=label%>: <%}%><%= value %>",multiTooltipTemplate:"<%= value %>",multiTooltipKeyBackground:"#fff",onAnimationProgress:function(){},onAnimationComplete:function(){}}},n.types={};var r=n.helpers={},i=r.each=function(e,t,n){var r=Array.prototype.slice.call(arguments,3);if(e)if(e.length===+e.length){var i;for(i=0;i<e.length;i++)t.apply(n,[e[i],i].concat(r))}else for(var s in e)t.apply(n,[e[s],s].concat(r))},s=r.clone=function(e){var t={};return i(e,function(n,r){e.hasOwnProperty(r)&&(t[r]=n)}),t},o=r.extend=function(e){return i(Array.prototype.slice.call(arguments,1),function(t){i(t,function(n,r){t.hasOwnProperty(r)&&(e[r]=n)})}),e},u=r.merge=function(e,t){var n=Array.prototype.slice.call(arguments,0);return n.unshift({}),o.apply(null,n)},a=r.indexOf=function(e,t){if(Array.prototype.indexOf)return e.indexOf(t);for(var n=0;n<e.length;n++)if(e[n]===t)return n;return-1},f=r.where=function(e,t){var n=[];return r.each(e,function(e){t(e)&&n.push(e)}),n},l=r.findNextWhere=function(e,t,n){n||(n=-1);for(var r=n+1;r<e.length;r++){var i=e[r];if(t(i))return i}},c=r.findPreviousWhere=function(e,t,n){n||(n=e.length);for(var r=n-1;r>=0;r--){var i=e[r];if(t(i))return i}},h=r.inherits=function(e){var t=this,n=e&&e.hasOwnProperty("constructor")?e.constructor:function(){return t.apply(this,arguments)},r=function(){this.constructor=n};return r.prototype=t.prototype,n.prototype=new r,n.extend=h,e&&o(n.prototype,e),n.__super__=t.prototype,n},p=r.noop=function(){},d=r.uid=function(){var e=0;return function(){return"chart-"+e++}}(),v=r.warn=function(e){window.console&&typeof window.console.warn=="function"&&console.warn(e)},m=r.amd=typeof define=="function"&&define.amd,g=r.isNumber=function(e){return!isNaN(parseFloat(e))&&isFinite(e)},y=r.max=function(e){return Math.max.apply(Math,e)},b=r.min=function(e){return Math.min.apply(Math,e)},w=r.cap=function(e,t,n){if(g(t)){if(e>t)return t}else if(g(n)&&e<n)return n;return e},E=r.getDecimalPlaces=function(e){return e%1!==0&&g(e)?e.toString().split(".")[1].length:0},S=r.radians=function(e){return e*(Math.PI/180)},x=r.getAngleFromPoint=function(e,t){var n=t.x-e.x,r=t.y-e.y,i=Math.sqrt(n*n+r*r),s=Math.PI*2+Math.atan2(r,n);return n<0&&r<0&&(s+=Math.PI*2),{angle:s,distance:i}},T=r.aliasPixel=function(e){return e%2===0?0:.5},N=r.splineCurve=function(e,t,n,r){var i=Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2)),s=Math.sqrt(Math.pow(n.x-t.x,2)+Math.pow(n.y-t.y,2)),o=r*i/(i+s),u=r*s/(i+s);return{inner:{x:t.x-o*(n.x-e.x),y:t.y-o*(n.y-e.y)},outer:{x:t.x+u*(n.x-e.x),y:t.y+u*(n.y-e.y)}}},C=r.calculateOrderOfMagnitude=function(e){return Math.floor(Math.log(e)/Math.LN10)},k=r.calculateScaleRange=function(e,t,n,r,i){var s=2,o=Math.floor(t/(n*1.5)),u=s>=o,a=y(e),f=b(e);a===f&&(a+=.5,f>=.5&&!r?f-=.5:a+=.5);var l=Math.abs(a-f),c=C(l),h=Math.ceil(a/(1*Math.pow(10,c)))*Math.pow(10,c),p=r?0:Math.floor(f/(1*Math.pow(10,c)))*Math.pow(10,c),d=h-p,v=Math.pow(10,c),m=Math.round(d/v);while((m>o||m*2<o)&&!u)if(m>o)v*=2,m=Math.round(d/v),m%1!==0&&(u=!0);else if(i&&c>=0){if(v/2%1!==0)break;v/=2,m=Math.round(d/v)}else v/=2,m=Math.round(d/v);return u&&(m=s,v=d/m),{steps:m,stepValue:v,min:p,max:p+m*v}},L=r.template=function(e,t){function r(e,t){var r=/\W/.test(e)?new Function("obj","var p=[],print=function(){p.push.apply(p,arguments);};with(obj){p.push('"+e.replace(/[\r\t\n]/g," ").split("<%").join("	").replace(/((^|%>)[^\t]*)'/g,"$1\r").replace(/\t=(.*?)%>/g,"',$1,'").split("	").join("');").split("%>").join("p.push('").split("\r").join("\\'")+"');}return p.join('');"):n[e]=n[e];return t?r(t):r}if(e instanceof Function)return e(t);var n={};return r(e,t)},A=r.generateLabels=function(e,t,n,r){var s=new Array(t);return labelTemplateString&&i(s,function(t,i){s[i]=L(e,{value:n+r*(i+1)})}),s},O=r.easingEffects={linear:function(e){return e},easeInQuad:function(e){return e*e},easeOutQuad:function(e){return-1*e*(e-2)},easeInOutQuad:function(e){return(e/=.5)<1?.5*e*e:-0.5*(--e*(e-2)-1)},easeInCubic:function(e){return e*e*e},easeOutCubic:function(e){return 1*((e=e/1-1)*e*e+1)},easeInOutCubic:function(e){return(e/=.5)<1?.5*e*e*e:.5*((e-=2)*e*e+2)},easeInQuart:function(e){return e*e*e*e},easeOutQuart:function(e){return-1*((e=e/1-1)*e*e*e-1)},easeInOutQuart:function(e){return(e/=.5)<1?.5*e*e*e*e:-0.5*((e-=2)*e*e*e-2)},easeInQuint:function(e){return 1*(e/=1)*e*e*e*e},easeOutQuint:function(e){return 1*((e=e/1-1)*e*e*e*e+1)},easeInOutQuint:function(e){return(e/=.5)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)},easeInSine:function(e){return-1*Math.cos(e/1*(Math.PI/2))+1},easeOutSine:function(e){return 1*Math.sin(e/1*(Math.PI/2))},easeInOutSine:function(e){return-0.5*(Math.cos(Math.PI*e/1)-1)},easeInExpo:function(e){return e===0?1:1*Math.pow(2,10*(e/1-1))},easeOutExpo:function(e){return e===1?1:1*(-Math.pow(2,-10*e/1)+1)},easeInOutExpo:function(e){return e===0?0:e===1?1:(e/=.5)<1?.5*Math.pow(2,10*(e-1)):.5*(-Math.pow(2,-10*--e)+2)},easeInCirc:function(e){return e>=1?e:-1*(Math.sqrt(1-(e/=1)*e)-1)},easeOutCirc:function(e){return 1*Math.sqrt(1-(e=e/1-1)*e)},easeInOutCirc:function(e){return(e/=.5)<1?-0.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)},easeInElastic:function(e){var t=1.70158,n=0,r=1;return e===0?0:(e/=1)==1?1:(n||(n=.3),r<Math.abs(1)?(r=1,t=n/4):t=n/(2*Math.PI)*Math.asin(1/r),-(r*Math.pow(2,10*(e-=1))*Math.sin((e*1-t)*2*Math.PI/n)))},easeOutElastic:function(e){var t=1.70158,n=0,r=1;return e===0?0:(e/=1)==1?1:(n||(n=.3),r<Math.abs(1)?(r=1,t=n/4):t=n/(2*Math.PI)*Math.asin(1/r),r*Math.pow(2,-10*e)*Math.sin((e*1-t)*2*Math.PI/n)+1)},easeInOutElastic:function(e){var t=1.70158,n=0,r=1;return e===0?0:(e/=1/2)==2?1:(n||(n=1*.3*1.5),r<Math.abs(1)?(r=1,t=n/4):t=n/(2*Math.PI)*Math.asin(1/r),e<1?-0.5*r*Math.pow(2,10*(e-=1))*Math.sin((e*1-t)*2*Math.PI/n):r*Math.pow(2,-10*(e-=1))*Math.sin((e*1-t)*2*Math.PI/n)*.5+1)},easeInBack:function(e){var t=1.70158;return 1*(e/=1)*e*((t+1)*e-t)},easeOutBack:function(e){var t=1.70158;return 1*((e=e/1-1)*e*((t+1)*e+t)+1)},easeInOutBack:function(e){var t=1.70158;return(e/=.5)<1?.5*e*e*(((t*=1.525)+1)*e-t):.5*((e-=2)*e*(((t*=1.525)+1)*e+t)+2)},easeInBounce:function(e){return 1-O.easeOutBounce(1-e)},easeOutBounce:function(e){return(e/=1)<1/2.75?1*7.5625*e*e:e<2/2.75?1*(7.5625*(e-=1.5/2.75)*e+.75):e<2.5/2.75?1*(7.5625*(e-=2.25/2.75)*e+.9375):1*(7.5625*(e-=2.625/2.75)*e+.984375)},easeInOutBounce:function(e){return e<.5?O.easeInBounce(e*2)*.5:O.easeOutBounce(e*2-1)*.5+.5}},M=r.requestAnimFrame=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(e){return window.setTimeout(e,1e3/60)}}(),_=r.cancelAnimFrame=function(){return window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(e){return window.clearTimeout(e,1e3/60)}}(),D=r.animationLoop=function(e,t,n,r,i,s){var o=0,u=O[n]||O.linear,a=function(){o++;var n=o/t,f=u(n);e.call(s,f,n,o),r.call(s,f,n),o<t?s.animationFrame=M(a):i.apply(s)};M(a)},P=r.getRelativePosition=function(e){var t,n,r=e.originalEvent||e,i=e.currentTarget||e.srcElement,s=i.getBoundingClientRect();return r.touches?(t=r.touches[0].clientX-s.left,n=r.touches[0].clientY-s.top):(t=r.clientX-s.left,n=r.clientY-s.top),{x:t,y:n}},H=r.addEvent=function(e,t,n){e.addEventListener?e.addEventListener(t,n):e.attachEvent?e.attachEvent("on"+t,n):e["on"+t]=n},B=r.removeEvent=function(e,t,n){e.removeEventListener?e.removeEventListener(t,n,!1):e.detachEvent?e.detachEvent("on"+t,n):e["on"+t]=p},j=r.bindEvents=function(e,t,n){e.events||(e.events={}),i(t,function(t){e.events[t]=function(){n.apply(e,arguments)},H(e.chart.canvas,t,e.events[t])})},F=r.unbindEvents=function(e,t){i(t,function(t,n){B(e.chart.canvas,n,t)})},I=r.getMaximumWidth=function(e){var t=e.parentNode;return t.clientWidth},q=r.getMaximumHeight=function(e){var t=e.parentNode;return t.clientHeight},R=r.getMaximumSize=r.getMaximumWidth,U=r.retinaScale=function(e){var t=e.ctx,n=e.canvas.width,r=e.canvas.height;window.devicePixelRatio&&(t.canvas.style.width=n+"px",t.canvas.style.height=r+"px",t.canvas.height=r*window.devicePixelRatio,t.canvas.width=n*window.devicePixelRatio,t.scale(window.devicePixelRatio,window.devicePixelRatio))},z=r.clear=function(e){e.ctx.clearRect(0,0,e.width,e.height)},W=r.fontString=function(e,t,n){return t+" "+e+"px "+n},X=r.longestText=function(e,t,n){e.font=t;var r=0;return i(n,function(t){var n=e.measureText(t).width;r=n>r?n:r}),r},V=r.drawRoundedRectangle=function(e,t,n,r,i,s){e.beginPath(),e.moveTo(t+s,n),e.lineTo(t+r-s,n),e.quadraticCurveTo(t+r,n,t+r,n+s),e.lineTo(t+r,n+i-s),e.quadraticCurveTo(t+r,n+i,t+r-s,n+i),e.lineTo(t+s,n+i),e.quadraticCurveTo(t,n+i,t,n+i-s),e.lineTo(t,n+s),e.quadraticCurveTo(t,n,t+s,n),e.closePath()};n.instances={},n.Type=function(e,t,r){this.options=t,this.chart=r,this.id=d(),n.instances[this.id]=this,t.responsive&&this.resize(),this.initialize.call(this,e)},o(n.Type.prototype,{initialize:function(){return this},clear:function(){return z(this.chart),this},stop:function(){return _(this.animationFrame),this},resize:function(e){this.stop();var t=this.chart.canvas,n=I(this.chart.canvas),r=this.options.maintainAspectRatio?n/this.chart.aspectRatio:q(this.chart.canvas);return t.width=this.chart.width=n,t.height=this.chart.height=r,U(this.chart),typeof e=="function"&&e.apply(this,Array.prototype.slice.call(arguments,1)),this},reflow:p,render:function(e){return e&&this.reflow(),this.options.animation&&!e?r.animationLoop(this.draw,this.options.animationSteps,this.options.animationEasing,this.options.onAnimationProgress,this.options.onAnimationComplete,this):(this.draw(),this.options.onAnimationComplete.call(this)),this},generateLegend:function(){return L(this.options.legendTemplate,this)},destroy:function(){this.clear(),F(this,this.events);var e=this.chart.canvas;e.width=this.chart.width,e.height=this.chart.height,e.style.removeProperty?(e.style.removeProperty("width"),e.style.removeProperty("height")):(e.style.removeAttribute("width"),e.style.removeAttribute("height")),delete n.instances[this.id]},showTooltip:function(e,t){typeof this.activeElements=="undefined"&&(this.activeElements=[]);var s=function(e){var t=!1;return e.length!==this.activeElements.length?(t=!0,t):(i(e,function(e,n){e!==this.activeElements[n]&&(t=!0)},this),t)}.call(this,e);if(!s&&!t)return;this.activeElements=e,this.draw(),this.options.customTooltips&&this.options.customTooltips(!1);if(e.length>0)if(this.datasets&&this.datasets.length>1){var o,u;for(var f=this.datasets.length-1;f>=0;f--){o=this.datasets[f].points||this.datasets[f].bars||this.datasets[f].segments,u=a(o,e[0]);if(u!==-1)break}var l=[],c=[],h=function(e){var t=[],n,i=[],s=[],o,a,f,h;return r.each(this.datasets,function(e){n=e.points||e.bars||e.segments,n[u]&&n[u].hasValue()&&t.push(n[u])}),r.each(t,function(e){i.push(e.x),s.push(e.y),l.push(r.template(this.options.multiTooltipTemplate,e)),c.push({fill:e._saved.fillColor||e.fillColor,stroke:e._saved.strokeColor||e.strokeColor})},this),h=b(s),a=y(s),f=b(i),o=y(i),{x:f>this.chart.width/2?f:o,y:(h+a)/2}}.call(this,u);(new n.MultiTooltip({x:h.x,y:h.y,xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,xOffset:this.options.tooltipXOffset,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,titleTextColor:this.options.tooltipTitleFontColor,titleFontFamily:this.options.tooltipTitleFontFamily,titleFontStyle:this.options.tooltipTitleFontStyle,titleFontSize:this.options.tooltipTitleFontSize,cornerRadius:this.options.tooltipCornerRadius,labels:l,legendColors:c,legendColorBackground:this.options.multiTooltipKeyBackground,title:e[0].label,chart:this.chart,ctx:this.chart.ctx,custom:this.options.customTooltips})).draw()}else i(e,function(e){var t=e.tooltipPosition();(new n.Tooltip({x:Math.round(t.x),y:Math.round(t.y),xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,caretHeight:this.options.tooltipCaretSize,cornerRadius:this.options.tooltipCornerRadius,text:L(this.options.tooltipTemplate,e),chart:this.chart,custom:this.options.customTooltips})).draw()},this);return this},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments)}}),n.Type.extend=function(e){var t=this,r=function(){return t.apply(this,arguments)};r.prototype=s(t.prototype),o(r.prototype,e),r.extend=n.Type.extend;if(e.name||t.prototype.name){var i=e.name||t.prototype.name,a=n.defaults[t.prototype.name]?s(n.defaults[t.prototype.name]):{};n.defaults[i]=o(a,e.defaults),n.types[i]=r,n.prototype[i]=function(e,t){var s=u(n.defaults.global,n.defaults[i],t||{});return new r(e,s,this)}}else v("Name not provided for this chart, so it hasn't been registered");return t},n.Element=function(e){o(this,e),this.initialize.apply(this,arguments),this.save()},o(n.Element.prototype,{initialize:function(){},restore:function(e){return e?i(e,function(e){this[e]=this._saved[e]},this):o(this,this._saved),this},save:function(){return this._saved=s(this),delete this._saved._saved,this},update:function(e){return i(e,function(e,t){this._saved[t]=this[t],this[t]=e},this),this},transition:function(e,t){return i(e,function(e,n){this[n]=(e-this._saved[n])*t+this._saved[n]},this),this},tooltipPosition:function(){return{x:this.x,y:this.y}},hasValue:function(){return g(this.value)}}),n.Element.extend=h,n.Point=n.Element.extend({display:!0,inRange:function(e,t){var n=this.hitDetectionRadius+this.radius;return Math.pow(e-this.x,2)+Math.pow(t-this.y,2)<Math.pow(n,2)},draw:function(){if(this.display){var e=this.ctx;e.beginPath(),e.arc(this.x,this.y,this.radius,0,Math.PI*2),e.closePath(),e.strokeStyle=this.strokeColor,e.lineWidth=this.strokeWidth,e.fillStyle=this.fillColor,e.fill(),e.stroke()}}}),n.Arc=n.Element.extend({inRange:function(e,t){var n=r.getAngleFromPoint(this,{x:e,y:t}),i=n.angle>=this.startAngle&&n.angle<=this.endAngle,s=n.distance>=this.innerRadius&&n.distance<=this.outerRadius;return i&&s},tooltipPosition:function(){var e=this.startAngle+(this.endAngle-this.startAngle)/2,t=(this.outerRadius-this.innerRadius)/2+this.innerRadius;return{x:this.x+Math.cos(e)*t,y:this.y+Math.sin(e)*t}},draw:function(e){var t=e||1,n=this.ctx;n.beginPath(),n.arc(this.x,this.y,this.outerRadius,this.startAngle,this.endAngle),n.arc(this.x,this.y,this.innerRadius,this.endAngle,this.startAngle,!0),n.closePath(),n.strokeStyle=this.strokeColor,n.lineWidth=this.strokeWidth,n.fillStyle=this.fillColor,n.fill(),n.lineJoin="bevel",this.showStroke&&n.stroke()}}),n.Rectangle=n.Element.extend({draw:function(){var e=this.ctx,t=this.width/2,n=this.x-t,r=this.x+t,i=this.base-(this.base-this.y),s=this.strokeWidth/2;this.showStroke&&(n+=s,r-=s,i+=s),e.beginPath(),e.fillStyle=this.fillColor,e.strokeStyle=this.strokeColor,e.lineWidth=this.strokeWidth,e.moveTo(n,this.base),e.lineTo(n,i),e.lineTo(r,i),e.lineTo(r,this.base),e.fill(),this.showStroke&&e.stroke()},height:function(){return this.base-this.y},inRange:function(e,t){return e>=this.x-this.width/2&&e<=this.x+this.width/2&&t>=this.y&&t<=this.base}}),n.Tooltip=n.Element.extend({draw:function(){var e=this.chart.ctx;e.font=W(this.fontSize,this.fontStyle,this.fontFamily),this.xAlign="center",this.yAlign="above";var t=this.caretPadding=2,n=e.measureText(this.text).width+2*this.xPadding,r=this.fontSize+2*this.yPadding,i=r+this.caretHeight+t;this.x+n/2>this.chart.width?this.xAlign="left":this.x-n/2<0&&(this.xAlign="right"),this.y-i<0&&(this.yAlign="below");var s=this.x-n/2,o=this.y-i;e.fillStyle=this.fillColor;if(this.custom)this.custom(this);else{switch(this.yAlign){case"above":e.beginPath(),e.moveTo(this.x,this.y-t),e.lineTo(this.x+this.caretHeight,this.y-(t+this.caretHeight)),e.lineTo(this.x-this.caretHeight,this.y-(t+this.caretHeight)),e.closePath(),e.fill();break;case"below":o=this.y+t+this.caretHeight,e.beginPath(),e.moveTo(this.x,this.y+t),e.lineTo(this.x+this.caretHeight,this.y+t+this.caretHeight),e.lineTo(this.x-this.caretHeight,this.y+t+this.caretHeight),e.closePath(),e.fill()}switch(this.xAlign){case"left":s=this.x-n+(this.cornerRadius+this.caretHeight);break;case"right":s=this.x-(this.cornerRadius+this.caretHeight)}V(e,s,o,n,r,this.cornerRadius),e.fill(),e.fillStyle=this.textColor,e.textAlign="center",e.textBaseline="middle",e.fillText(this.text,s+n/2,o+r/2)}}}),n.MultiTooltip=n.Element.extend({initialize:function(){this.font=W(this.fontSize,this.fontStyle,this.fontFamily),this.titleFont=W(this.titleFontSize,this.titleFontStyle,this.titleFontFamily),this.height=this.labels.length*this.fontSize+(this.labels.length-1)*(this.fontSize/2)+this.yPadding*2+this.titleFontSize*1.5,this.ctx.font=this.titleFont;var e=this.ctx.measureText(this.title).width,t=X(this.ctx,this.font,this.labels)+this.fontSize+3,n=y([t,e]);this.width=n+this.xPadding*2;var r=this.height/2;this.y-r<0?this.y=r:this.y+r>this.chart.height&&(this.y=this.chart.height-r),this.x>this.chart.width/2?this.x-=this.xOffset+this.width:this.x+=this.xOffset},getLineHeight:function(e){var t=this.y-this.height/2+this.yPadding,n=e-1;return e===0?t+this.titleFontSize/2:t+(this.fontSize*1.5*n+this.fontSize/2)+this.titleFontSize*1.5},draw:function(){if(this.custom)this.custom(this);else{V(this.ctx,this.x,this.y-this.height/2,this.width,this.height,this.cornerRadius);var e=this.ctx;e.fillStyle=this.fillColor,e.fill(),e.closePath(),e.textAlign="left",e.textBaseline="middle",e.fillStyle=this.titleTextColor,e.font=this.titleFont,e.fillText(this.title,this.x+this.xPadding,this.getLineHeight(0)),e.font=this.font,r.each(this.labels,function(t,n){e.fillStyle=this.textColor,e.fillText(t,this.x+this.xPadding+this.fontSize+3,this.getLineHeight(n+1)),e.fillStyle=this.legendColorBackground,e.fillRect(this.x+this.xPadding,this.getLineHeight(n+1)-this.fontSize/2,this.fontSize,this.fontSize),e.fillStyle=this.legendColors[n].fill,e.fillRect(this.x+this.xPadding,this.getLineHeight(n+1)-this.fontSize/2,this.fontSize,this.fontSize)},this)}}}),n.Scale=n.Element.extend({initialize:function(){this.fit()},buildYLabels:function(){this.yLabels=[];var e=E(this.stepValue);for(var t=0;t<=this.steps;t++)this.yLabels.push(L(this.templateString,{value:(this.min+t*this.stepValue).toFixed(e)}));this.yLabelWidth=this.display&&this.showLabels?X(this.ctx,this.font,this.yLabels):0},addXLabel:function(e){this.xLabels.push(e),this.valuesCount++,this.fit()},removeXLabel:function(){this.xLabels.shift(),this.valuesCount--,this.fit()},fit:function(){this.startPoint=this.display?this.fontSize:0,this.endPoint=this.display?this.height-this.fontSize*1.5-5:this.height,this.startPoint+=this.padding,this.endPoint-=this.padding;var e=this.endPoint-this.startPoint,t;this.calculateYRange(e),this.buildYLabels(),this.calculateXLabelRotation();while(e>this.endPoint-this.startPoint)e=this.endPoint-this.startPoint,t=this.yLabelWidth,this.calculateYRange(e),this.buildYLabels(),t<this.yLabelWidth&&this.calculateXLabelRotation()},calculateXLabelRotation:function(){this.ctx.font=this.font;var e=this.ctx.measureText(this.xLabels[0]).width,t=this.ctx.measureText(this.xLabels[this.xLabels.length-1]).width,n,r;this.xScalePaddingRight=t/2+3,this.xScalePaddingLeft=e/2>this.yLabelWidth+10?e/2:this.yLabelWidth+10,this.xLabelRotation=0;if(this.display){var i=X(this.ctx,this.font,this.xLabels),s,o;this.xLabelWidth=i;var u=Math.floor(this.calculateX(1)-this.calculateX(0))-6;while(this.xLabelWidth>u&&this.xLabelRotation===0||this.xLabelWidth>u&&this.xLabelRotation<=90&&this.xLabelRotation>0)s=Math.cos(S(this.xLabelRotation)),n=s*e,r=s*t,n+this.fontSize/2>this.yLabelWidth+8&&(this.xScalePaddingLeft=n+this.fontSize/2),this.xScalePaddingRight=this.fontSize/2,this.xLabelRotation++,this.xLabelWidth=s*i;this.xLabelRotation>0&&(this.endPoint-=Math.sin(S(this.xLabelRotation))*i+3)}else this.xLabelWidth=0,this.xScalePaddingRight=this.padding,this.xScalePaddingLeft=this.padding},calculateYRange:p,drawingArea:function(){return this.startPoint-this.endPoint},calculateY:function(e){var t=this.drawingArea()/(this.min-this.max);return this.endPoint-t*(e-this.min)},calculateX:function(e){var t=this.xLabelRotation>0,n=this.width-(this.xScalePaddingLeft+this.xScalePaddingRight),r=n/Math.max(this.valuesCount-(this.offsetGridLines?0:1),1),i=r*e+this.xScalePaddingLeft;return this.offsetGridLines&&(i+=r/2),Math.round(i)},update:function(e){r.extend(this,e),this.fit()},draw:function(){var e=this.ctx,t=(this.endPoint-this.startPoint)/this.steps,n=Math.round(this.xScalePaddingLeft);this.display&&(e.fillStyle=this.textColor,e.font=this.font,i(this.yLabels,function(i,s){var o=this.endPoint-t*s,u=Math.round(o),a=this.showHorizontalLines;e.textAlign="right",e.textBaseline="middle",this.showLabels&&e.fillText(i,n-10,o),s===0&&!a&&(a=!0),a&&e.beginPath(),s>0?(e.lineWidth=this.gridLineWidth,e.strokeStyle=this.gridLineColor):(e.lineWidth=this.lineWidth,e.strokeStyle=this.lineColor),u+=r.aliasPixel(e.lineWidth),a&&(e.moveTo(n,u),e.lineTo(this.width,u),e.stroke(),e.closePath()),e.lineWidth=this.lineWidth,e.strokeStyle=this.lineColor,e.beginPath(),e.moveTo(n-5,u),e.lineTo(n,u),e.stroke(),e.closePath()},this),i(this.xLabels,function(t,n){var r=this.calculateX(n)+T(this.lineWidth),i=this.calculateX(n-(this.offsetGridLines?.5:0))+T(this.lineWidth),s=this.xLabelRotation>0,o=this.showVerticalLines;n===0&&!o&&(o=!0),o&&e.beginPath(),n>0?(e.lineWidth=this.gridLineWidth,e.strokeStyle=this.gridLineColor):(e.lineWidth=this.lineWidth,e.strokeStyle=this.lineColor),o&&(e.moveTo(i,this.endPoint),e.lineTo(i,this.startPoint-3),e.stroke(),e.closePath()),e.lineWidth=this.lineWidth,e.strokeStyle=this.lineColor,e.beginPath(),e.moveTo(i,this.endPoint),e.lineTo(i,this.endPoint+5),e.stroke(),e.closePath(),e.save(),e.translate(r,s?this.endPoint+12:this.endPoint+8),e.rotate(S(this.xLabelRotation)*-1),e.font=this.font,e.textAlign=s?"right":"center",e.textBaseline=s?"middle":"top",e.fillText(t,0,0),e.restore()},this))}}),n.RadialScale=n.Element.extend({initialize:function(){this.size=b([this.height,this.width]),this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2},calculateCenterOffset:function(e){var t=this.drawingArea/(this.max-this.min);return(e-this.min)*t},update:function(){this.lineArc?this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2:this.setScaleSize(),this.buildYLabels()},buildYLabels:function(){this.yLabels=[];var e=E(this.stepValue);for(var t=0;t<=this.steps;t++)this.yLabels.push(L(this.templateString,{value:(this.min+t*this.stepValue).toFixed(e)}))},getCircumference:function(){return Math.PI*2/this.valuesCount},setScaleSize:function(){var e=b([this.height/2-this.pointLabelFontSize-5,this.width/2]),t,n,r,i,s=this.width,o,u,a=0,f,l,c,h,p,d,v;this.ctx.font=W(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily);for(n=0;n<this.valuesCount;n++)t=this.getPointPosition(n,e),r=this.ctx.measureText(L(this.templateString,{value:this.labels[n]})).width+5,n===0||n===this.valuesCount/2?(i=r/2,t.x+i>s&&(s=t.x+i,o=n),t.x-i<a&&(a=t.x-i,f=n)):n<this.valuesCount/2?t.x+r>s&&(s=t.x+r,o=n):n>this.valuesCount/2&&t.x-r<a&&(a=t.x-r,f=n);c=a,h=Math.ceil(s-this.width),u=this.getIndexAngle(o),l=this.getIndexAngle(f),p=h/Math.sin(u+Math.PI/2),d=c/Math.sin(l+Math.PI/2),p=g(p)?p:0,d=g(d)?d:0,this.drawingArea=e-(d+p)/2,this.setCenterPoint(d,p)},setCenterPoint:function(e,t){var n=this.width-t-this.drawingArea,r=e+this.drawingArea;this.xCenter=(r+n)/2,this.yCenter=this.height/2},getIndexAngle:function(e){var t=Math.PI*2/this.valuesCount;return e*t-Math.PI/2},getPointPosition:function(e,t){var n=this.getIndexAngle(e);return{x:Math.cos(n)*t+this.xCenter,y:Math.sin(n)*t+this.yCenter}},draw:function(){if(this.display){var e=this.ctx;i(this.yLabels,function(t,n){if(n>0){var r=n*(this.drawingArea/this.steps),i=this.yCenter-r,s;if(this.lineWidth>0){e.strokeStyle=this.lineColor,e.lineWidth=this.lineWidth;if(this.lineArc)e.beginPath(),e.arc(this.xCenter,this.yCenter,r,0,Math.PI*2),e.closePath(),e.stroke();else{e.beginPath();for(var o=0;o<this.valuesCount;o++)s=this.getPointPosition(o,this.calculateCenterOffset(this.min+n*this.stepValue)),o===0?e.moveTo(s.x,s.y):e.lineTo(s.x,s.y);e.closePath(),e.stroke()}}if(this.showLabels){e.font=W(this.fontSize,this.fontStyle,this.fontFamily);if(this.showLabelBackdrop){var u=e.measureText(t).width;e.fillStyle=this.backdropColor,e.fillRect(this.xCenter-u/2-this.backdropPaddingX,i-this.fontSize/2-this.backdropPaddingY,u+this.backdropPaddingX*2,this.fontSize+this.backdropPaddingY*2)}e.textAlign="center",e.textBaseline="middle",e.fillStyle=this.fontColor,e.fillText(t,this.xCenter,i)}}},this);if(!this.lineArc){e.lineWidth=this.angleLineWidth,e.strokeStyle=this.angleLineColor;for(var t=this.valuesCount-1;t>=0;t--){if(this.angleLineWidth>0){var n=this.getPointPosition(t,this.calculateCenterOffset(this.max));e.beginPath(),e.moveTo(this.xCenter,this.yCenter),e.lineTo(n.x,n.y),e.stroke(),e.closePath()}var r=this.getPointPosition(t,this.calculateCenterOffset(this.max)+5);e.font=W(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily),e.fillStyle=this.pointLabelFontColor;var s=this.labels.length,o=this.labels.length/2,u=o/2,a=t<u||t>s-u,f=t===u||t===s-u;t===0?e.textAlign="center":t===o?e.textAlign="center":t<o?e.textAlign="left":e.textAlign="right",f?e.textBaseline="middle":a?e.textBaseline="bottom":e.textBaseline="top",e.fillText(this.labels[t],r.x,r.y)}}}}}),r.addEvent(window,"resize",function(){var e;return function(){clearTimeout(e),e=setTimeout(function(){i(n.instances,function(e){e.options.responsive&&e.resize(e.render,!0)})},50)}}()),m?define(function(){return n}):typeof module=="object"&&module.exports&&(module.exports=n),e.Chart=n,n.noConflict=function(){return e.Chart=t,n}}).call(this);var cssColorParser=function(){function t(e){return e=Math.round(e),e<0?0:e>255?255:e}function n(e){return e<0?0:e>1?1:e}function r(e){return e[e.length-1]==="%"?t(parseFloat(e)/100*255):t(parseInt(e))}function i(e){return e[e.length-1]==="%"?n(parseFloat(e)/100):n(parseFloat(e))}function s(e,t,n){return n<0?n+=1:n>1&&(n-=1),n*6<1?e+(t-e)*n*6:n*2<1?t:n*3<2?e+(t-e)*(2/3-n)*6:e}function o(n){var o=n.replace(/ /g,"").toLowerCase();if(o in e)return e[o].slice();if(o[0]==="#"){if(o.length===4){var u=parseInt(o.substr(1),16);return u>=0&&u<=4095?[(u&3840)>>4|(u&3840)>>8,u&240|(u&240)>>4,u&15|(u&15)<<4,1]:null}if(o.length===7){var u=parseInt(o.substr(1),16);return u>=0&&u<=16777215?[(u&16711680)>>16,(u&65280)>>8,u&255,1]:null}return null}var a=o.indexOf("("),f=o.indexOf(")");if(a!==-1&&f+1===o.length){var l=o.substr(0,a),c=o.substr(a+1,f-(a+1)).split(","),h=1;switch(l){case"rgba":if(c.length!==4)return null;h=i(c.pop());case"rgb":if(c.length!==3)return null;return[r(c[0]),r(c[1]),r(c[2]),h];case"hsla":if(c.length!==4)return null;h=i(c.pop());case"hsl":if(c.length!==3)return null;var p=(parseFloat(c[0])%360+360)%360/360,d=i(c[1]),v=i(c[2]),m=v<=.5?v*(d+1):v+d-v*d,g=v*2-m;return[t(s(g,m,p+1/3)*255),t(s(g,m,p)*255),t(s(g,m,p-1/3)*255),h];default:return null}}return null}var e={rebeccapurple:[102,51,153],transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen
:[154,205,50,1]};return o}(),ColorManager=function(){function e(e,n,r,i){return e=t(e,0,255),n=t(n,0,255),r=t(r,0,255),i=t(i,0,255),"rgba("+Math.floor(e)+","+Math.floor(n)+","+Math.floor(r)+","+i+")"}function t(e,t,n){return Math.max(t,Math.min(e,n))}function n(e,t,n){return t*n+e*(1-n)}function r(e,t,r,i){var s=(t-r)*i,o=Math.floor(s),u=s-o,a=o+1;return a>e.length-1&&(a=o),{r:n(e[o][0],e[a][0],u),g:n(e[o][1],e[a][1],u),b:n(e[o][2],e[a][2],u),a:n(e[o][3],e[a][3],u)}}function i(e,t,n,r){var i=Math.floor((t-n)*r);return{r:e[i][0],g:e[i][1],b:e[i][2],a:e[i][3]}}function s(e,t){return e*=t,e>255?255:e}function o(e,t){return{r:s(e.r,t),g:s(e.g,t),b:s(e.b,t),a:e.a}}function u(e){return cssColorParser(e)}this.getColor=function(){console.error("ColorManager: colors have not been setup")},this.colors=[],this.setup=function(t,n,s,a,f){var l,c,h=n-t,p=t;a==="gradient"?(l=r,c=(s.length-1)/(h-1)):(l=i,c=s.length/(h+1)),this.colors=s.map(function(e){return u(e)}),this.getColor=function(t){var n=l(this.colors,t,p,c),r=o(n,f);return{color:e(n.r,n.g,n.b,n.a),highlight:e(r.r,r.g,r.b,r.a)}}}};(function(){"use strict";var e=this,t=e.Chart,n=t.helpers,r={backgroundColor:"#fff",stroke:!1,strokePerc:.05,strokeColor:"rgb(128,128,128)",highlightStrokeColor:"rgb(192,192,192)",rounded:!0,roundedRadius:.1,paddingScale:.05,colorInterpolation:"gradient",colors:["rgba(220,220,220,0.9)","rgba(151,187,205,0.9)"],colorHighlight:!0,colorHighlightMultiplier:.92,showLabels:!0,labelScale:.2,labelFontFamily:'"HelveticaNeue-Light", "Helvetica Neue Light", "Helvetica Neue", Helvetica, Arial, "Lucida Grande", sans-serif',labelFontStyle:"normal",labelFontColor:"rgba(0,0,0,0.5)",tooltipTemplate:"<%= xLabel %> | <%= yLabel %> : <%= value %>",legendTemplate:'<div class="<%= name.toLowerCase() %>-legend"><span class="<%= name.toLowerCase() %>-legend-text"><%= min %></span><% for (var i = min; i <= max; i += (max-min)/6){ %><span class="<%= name.toLowerCase() %>-legend-box" style="background-color: <%= colorManager.getColor(i).color %>;">&nbsp; </span><% } %><span class="<%= name.toLowerCase() %>-legend-text"><%= max %></span></div>'};t.Type.extend({name:"HeatMap",defaults:r,initialize:function(e){var r=this.options;this.max=-Infinity,this.min=Infinity,this.colorManager=new ColorManager,this.ScaleClass=t.Scale.extend({offsetGridLines:!0,calculateBaseWidth:function(){return this.calculateX(1)-this.calculateX(0)},calculateBoxWidth:function(e,t){var n=this.calculateBaseWidth()-e-1,r=Math.max(e,t);return this.calculateBaseWidth()},calculateBoxHeight:function(){return this.calculateY(0)-this.calculateY(1)},buildYLabels:function(){this.yLabelWidth=this.display&&this.showLabels?n.longestText(this.ctx,this.font,this.yLabels):0},draw:function(){var e=this.ctx,t=(this.endPoint-this.startPoint)/this.steps,r=Math.round(this.xScalePaddingLeft);this.display&&(e.fillStyle=this.textColor,e.font=this.font,n.each(this.yLabels,function(n,i){var s=this.endPoint-t*i-t*.5,o=Math.round(s),u=this.showHorizontalLines;e.textAlign="right",e.textBaseline="middle",this.showLabels&&e.fillText(n,r-10,s)},this),n.each(this.xLabels,function(t,r){var i=this.calculateX(r)+n.aliasPixel(this.lineWidth),s=this.calculateX(r-(this.offsetGridLines?.5:0))+n.aliasPixel(this.lineWidth),o=this.xLabelRotation>0,u=this.showVerticalLines;e.lineWidth=this.lineWidth,e.strokeStyle=this.lineColor,e.save(),e.translate(i,o?this.endPoint+12:this.endPoint+8),e.rotate(n.radians(this.xLabelRotation)*-1),e.font=this.font,e.textAlign=o?"right":"center",e.textBaseline=o?"middle":"top",e.fillText(t,0,0),e.restore()},this))}}),this.datasets=[],this.yLabels=[],this.xLabels=e.labels,this.options.showTooltips&&n.bindEvents(this,this.options.tooltipEvents,function(e){var t=e.type!=="mouseout"?this.getBoxAtEvent(e):undefined;this.activeElement=t,this.eachBoxes(function(e){e.restore(["fillColor","strokeColor"])}),t&&(t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke),this.showTooltip(t)}),this.BoxClass=t.Rectangle.extend({strokePerc:this.options.strokePerc,strokeColor:this.options.strokeColor,showStroke:this.options.stroke,fontColor:this.options.labelFontColor,fontFamily:this.options.labelFontFamily,fontScale:this.options.labelScale,showLabels:this.options.showLabels,radiusScale:this.options.rounded?this.options.roundedRadius:0,paddingScale:this.options.paddingScale,ctx:this.chart.ctx,draw:function(){var e=this.ctx,t=this.width/2,r=this.width,i=this.height,s=this.x-t,o=this.y,u=this.strokePerc*this.width,a=u/2,f=this.paddingScale*r,l=this.paddingScale*i;s+=f*.5,o+=l*.5,r-=f,i-=l,this.showStroke&&(s+=a,r-=a,i-=a,o+=a),e.fillStyle=this.fillColor,e.strokeStyle=this.strokeColor,e.lineWidth=u,n.drawRoundedRectangle(e,s,o,r,i,this.radiusScale*this.width),e.fill(),this.showStroke&&e.stroke(),this.showLabels&&this.label!==null&&this.label!==undefined&&(e.textAlign="center",e.textBaseline="middle",e.fillStyle=this.fontColor,e.font=this.height*this.fontScale+"px "+this.fontFamily,e.fillText(this.value,s+r*.5,o+i*.5))}}),n.each(e.datasets,function(e,t){var r={label:e.label||null,boxes:[]};this.datasets.push(r),this.yLabels.push(e.label),n.each(e.data,function(t,n){r.boxes.push(new this.BoxClass({value:t,label:this.xLabels[n],datasetLabel:e.label,strokeColor:this.options.strokeColor,fillColor:"white",highlightFill:"black",highlightStroke:this.options.highlightStrokeColor}))},this)},this),this.datasets.reverse(),this.yLabels.reverse(),this.buildScale(e.labels,this.yLabels),this.BoxClass.prototype.base=this.scale.endPoint,this.eachBoxes(function(e,t,r){n.extend(e,{x:this.scale.calculateX(t),y:this.scale.calculateY(r+1),width:this.scale.calculateBoxWidth(),height:this.scale.calculateBoxHeight()}),e.save()},this),this.findMaxAndMin(!0),this.applyColors(),this.render()},update:function(){this.scale.update(),this.activeElement&&this.activeElement.restore(["fillColor","strokeColor"]),this.eachBoxes(function(e){e.save()}),this.render()},eachBoxes:function(e){n.each(this.datasets,function(t,r){n.each(t.boxes,e,this,r)},this)},getBoxAtEvent:function(e){var t=n.getRelativePosition(e),r;for(var i=0;i<this.datasets.length;i++)for(r=0;r<this.datasets[i].boxes.length;r++)if(this.datasets[i].boxes[r].inRange(t.x,t.y))return this.datasets[i].boxes[r];return undefined},buildScale:function(e,t){var r=this,i=function(){var e=[];return r.eachBoxes(function(t){e.push(t.value)}),e},s={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:e.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(e){var t={min:0,max:r.datasets.length,steps:r.datasets.length,stepValue:1};n.extend(this,t)},xLabels:e,yLabels:t,font:n.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:this.options.scaleShowGridLines?this.options.scaleGridLineWidth:0,gridLineColor:this.options.scaleShowGridLines?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:this.options.showScale?0:this.options.stroke?this.options.strokeWidth:0,showLabels:this.options.scaleShowLabels,display:this.options.showScale};this.scale=new this.ScaleClass(s)},addDataset:function(e,t){var r={label:t,boxes:[]},i=this.datasets.length;n.each(e,function(e,n){r.boxes.push(new this.BoxClass({value:e,label:this.xLabels[n],x:this.scale.calculateX(n),y:this.scale.calculateY(0),width:this.scale.calculateBoxWidth()+1,height:this.scale.calculateBoxHeight()+1,datasetLabel:t,strokeColor:this.options.strokeColor,highlightStroke:this.options.highlightStrokeColor}))},this),this.datasets.unshift(r),this.scale.yLabels.unshift(t),this.scale.steps+=1,this.scale.max+=1,this.scale.fit(),this.findMaxAndMin(!0),this.applyColors(),this.update()},removeDataset:function(){this.datasets.pop(),this.scale.yLabels.pop(),this.scale.steps-=1,this.scale.max-=1,this.scale.fit(),this.findMaxAndMin(!0),this.applyColors(),this.update()},applyColors:function(){this.colorManager.setup(this.min,this.max,this.options.colors,this.options.colorInterpolation,this.options.colorHighlightMultiplier),this.eachBoxes(function(e){var t=this.colorManager.getColor(e.value);e.fillColor=t.color,e.highlightFill=t.highlight,e.strokeColor=this.options.strokeColor,e.highlightStroke=this.options.highlightStrokeColor,e.save()})},findMaxAndMin:function(e){e&&(this.min=Infinity,this.max=-Infinity),this.eachBoxes(function(e,t,n){e.value>this.max&&(this.max=e.value),e.value<this.min&&(this.min=e.value)})},addData:function(e,t){e=e.concat().reverse();var r=this.datasets[0].boxes.length;n.each(e,function(e,n){this.datasets[n].boxes.push(new this.BoxClass({value:e,label:t,datasetLabel:this.datasets[n].label,x:this.scale.calculateX(r),y:this.scale.calculateY(n+1),width:this.scale.calculateBoxWidth()+1,height:this.scale.calculateBoxHeight()+1,strokeColor:this.options.strokeColor,highlightStroke:this.options.highlightStrokeColor}))},this),this.findMaxAndMin(!0),this.applyColor(),this.scale.addXLabel(t),this.update()},removeData:function(){this.scale.removeXLabel(),n.each(this.datasets,function(e){e.boxes.shift()},this),this.findMaxAndMin(!0),this.applyColors(),this.update()},reflow:function(){n.extend(this.BoxClass.prototype,{y:this.scale.endPoint,base:this.scale.endPoint});var e=n.extend({height:this.chart.height,width:this.chart.width});this.scale.update(e)},showTooltip:function(e){this.draw();if(e){var r=e.tooltipPosition(),i={yLabel:e.datasetLabel,xLabel:e.label,value:e.value};(new t.Tooltip({x:Math.round(r.x),y:Math.round(r.y+20),xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,caretHeight:this.options.tooltipCaretSize,cornerRadius:this.options.tooltipCornerRadius,text:n.template(this.options.tooltipTemplate,i),chart:this.chart,custom:this.options.customTooltips})).draw()}return this},draw:function(e){var t=e||1;this.clear(),this.scale.draw(t),this.eachBoxes(function(e,n,r){e.transition({x:this.scale.calculateX(n),y:this.scale.calculateY(r+1),width:this.scale.calculateBoxWidth()+1,height:this.scale.calculateBoxHeight()+1},t).draw()})}})}).call(this);