@extends('layouts.app')
@section('title','Roles')
@section('content')
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-12">
                <div class="page-header-title">
                    <h5>Roles</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}"><i class="feather icon-home"></i></a></li>
                    <li class="breadcrumb-item"><a href="#!">Permisos</a></li>
                    <li class="breadcrumb-item"><a href="#!">Roles</a></li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <h4>Listado de Roles</h4>
                    @can('roles.create')
                        <a href="{{ route('roles.create') }}" class="btn btn-primary btn-round">Crear Nuevo Rol</a>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover  table-sm">
                        <thead>
                            <tr>
                                <th class="text-center" >Acciones</th>
                                <th class="text-center">Rol</th>
                                <th class="text-center ">Descripción</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($roles as $role)
                                <tr>
                                    <td class="text-center">
                                        <div class="d-flex justify-content-center">
                                            @can('roles.show')
                                                <button class="btn"><a href="{{route('roles.show',$role->id)}}" data-toggle="tooltip" title="Ver los permisos asignados al rol"><i class="fas fa-eye"></i></a></button>
                                            @endcan
                                            @can('roles.edit')
                                                <button class="btn"><a href="{{route('roles.edit',$role->id)}}" data-toggle="tooltip" title="Modificar Permisos asignados al rol" ><i class="fas fa-edit"></i></a></button>
                                            @endcan
                                            @can('roles.destroy')
                                                {!! Form::open(['route'=>['roles.destroy',$role->id],'method'=>'DELETE']) !!}
                                                    <button class="btn text-danger" data-toggle="tooltip" title="Eliminar rol" onclick="return confirm('¿Está seguro que desea eliminar el rol?');"><i class="fas fa-trash-alt"></i></button>
                                                {!! Form::close() !!}
                                            @endcan
                                        </div>
                                    </td>
                                    <td class="fw-bold">{{$role->name}}</td>
                                    <td class="text-wrap">{{$role->descripcion}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
    
@endsection