<p>Debe rellenar todos los campos marcados con <strong class="text-danger">(*)</strong>.
    Al momento de registrar/editar un usuario, debe asignarle un rol, para que pueda solo ver y administrar la información que corresponda</p>
@if ($errors->any())
    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
    <ul class="list-ticked mensaje-error">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="row mb-1 ">
    <label for="empleado_ci" class="col-md-4 col-form-label text-right">Funcionario </label>
    <div class="col-md-6 mb-0 pb-0">
        <select name="empleado_ci"  class="form-control form-control {{ $errors->has('empleado_ci') ? ' is-invalid' : '' }}" id="empleado_ci"  data-ruta="{{ route('datos_empleado') }}">
            <option value="">--BUSQUE Y SELECCIONE--</option>
            @foreach($empleados as $empleado)
                <option value="{{$empleado->ci}}" {{ old('empleado_ci', $user->empleado_ci)== $empleado->ci ? 'selected' : '' }}>{{ $empleado->login }} - {{ $empleado->nombre }} - {{ $empleado->cargo }} - {{ $empleado->unidad }} - {{ $empleado->area }} - {{ $empleado->entidad }} - {{ $empleado->ci }}</option>
            @endforeach
        </select>
    </div>
</div> 


<div class="row mb-1 ">
    <label for="name" class="col-md-4 col-form-label text-right">Nombre Completo <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="name" type="text" class="form-control {{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name',$user->name) }}"  autofocus onkeyup="javascript:this.value=this.value.toUpperCase();" >
    </div>
</div>
<div class="row mb-1 ">
    <label for="ci" class="col-md-4 col-form-label text-right">CI <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="ci" type="text" class="form-control {{ $errors->has('ci') ? ' is-invalid' : '' }}" name="ci" value="{{ old('ci',$user->ci) }}">
    </div>
</div>
<div class="row mb-1 ">
    <label for="cargo" class="col-md-4 col-form-label text-right">Cargo <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="cargo" type="text" class="form-control {{ $errors->has('cargo') ? ' is-invalid' : '' }}" name="cargo" value="{{ old('cargo',$user->cargo) }}" autofocus onkeyup="javascript:this.value=this.value.toUpperCase();">
    </div>
</div>
<div class="row mb-1 ">
    <label for="unidad_rrhh" class="col-md-4 col-form-label text-right">Unidad_rrhh <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="unidad_rrhh" type="text" class="form-control {{ $errors->has('unidad_rrhh') ? ' is-invalid' : '' }}" name="unidad_rrhh" value="{{ old('unidad_rrhh',$user->unidad_rrhh) }}" autofocus onkeyup="javascript:this.value=this.value.toUpperCase();">
    </div>
</div>
<div class="row mb-1 ">
    <label for="role_id" class="col-md-4 col-form-label text-right">Rol <span class="text-danger">(*)</span></label>
    <div class="col-md-6 mb-0 pb-0">
        <select name="role_id"  class="form-control form-control {{ $errors->has('role_id') ? ' is-invalid' : '' }}" id="role_id" onchange="changeRol(this)">
            <option value="">--SELECCIONE--</option>
            @foreach($roles as $rol)
                {{-- @if($rol->id != 1) --}}
                    <option value="{{$rol->id}}" {{ old('role_id',count($user->rol)>0 ? $user->rol[0]->id :'')== $rol->id ? 'selected' : '' }}>{{$rol->name}} <em>({{$rol->descripcion}})</em></option>
                {{-- @endif --}}
            @endforeach
        </select>
    </div>
</div>
<div class="row mb-1 ">
    <label for="username" class="col-md-4 col-form-label text-right">Nombre de Usuario <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="username" type="text" class="form-control {{ $errors->has('username') ? ' is-invalid' : '' }}" name="username" value="{{ old('username',$user->username) }}" >
    </div>
</div>
<div class="row mb-1 ">
    <label for="email" class="col-md-4 col-form-label text-right ">Correo institucional <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email',$user->email) }}">
    </div>
</div>

<div class="row mb-0 ">
    <label for="password" class="col-md-4 col-form-label text-right ">{{ $texto_pass }} @if($tipo==1) <span class="text-danger">(*)</span> @endif</label>

    <div class="col-md-6">
        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="new-password">
    </div>
</div>
@if($tipo==1)
    <div class="row mt-1">
        <label for="password-confirm" class="col-md-4 col-form-label text-right ">{{ __('Confirm Password') }} <span class="text-danger">(*)</span></label>
        <div class="col-md-6">
            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" >
        </div>
    </div>
@endif
<div class="text-center mt-3">
    <button type="submit" class="btn btn-{{ $color }}">{{ $texto }}</button>
    <a href="{{ route('users.index') }}" class="btn btn-warning">Salir</a>
</div>