@if($errors->any())
    <div class="alert alert-outline-danger">
        <strong>Debe corregir los siguientes errores:</strong>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<div class="row">
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="entidad_id">Entidad</label>
            <select name="entidad_id" id="entidad_id" class="form-control @error('entidad_id') error @enderror">
                <option value="">--SELECCIONE--</option>
                @foreach ($entidades as $entidad)
                    <option value="{{ $entidad->id }}" {{ old('entidad_id',$contrato->entidad_id) == $entidad->id ? 'selected' : '' }}>{{ $entidad->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="col-md-8 col-sm-12">
        <div class="form-group">
            <label for="responsable_id">Técnico Asignado</label>
            <select name="responsable_id" id="responsable_id" class="form-control  @error('responsable_id') error @enderror" data-original="{{ $contrato->ultimaAsignacion ? $contrato->ultimaAsignacion->responsable_id :'' }}">
                <option value="">--SELECCIONE--</option>
                @foreach ($responsables as $responsable)
                    <option value="{{ $responsable->id }}" {{ old('responsable_id',$contrato->ultimaAsignacion ? $contrato->ultimaAsignacion->responsable_id :'') == $responsable->id ? 'selected' : '' }}>{{ $responsable->name }}</option>
                @endforeach
            </select>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="nuri">NURI <span class="text-danger">(*)</span></label>
            {{-- <select name="" id="" class="form-control"></select> --}}
            <input type="text" class="form-control @error('nuri') error @enderror" id="nuri" name="nuri" value="{{ old('nuri') ?? $contrato->nuri }}" placeholder="Ingrese el NURI del contrato">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="codigo_pac">Código del PAC</label>
            <input type="text" class="form-control @error('codigo_pac') error @enderror" id="codigo_pac" name="codigo_pac" value="{{ old('codigo_pac') ?? $contrato->codigo_pac }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="fecha_ingreso">Fecha de Ingreso <span class="text-danger">(*)</span></label>
            <input type="date" class="form-control @error('fecha_ingreso') error @enderror" id="fecha_ingreso" name="fecha_ingreso" value="{{ old('fecha_ingreso') ?? date('Y-m-d', strtotime($contrato->fecha_ingreso ?? date('Y-m-d'))) }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="tipo_gasto_id">Inversión / Gasto Corriente <span class="text-danger">(*)</span></label>
            <select class="form-control @error('tipo_gasto_id') error @enderror" id="tipo_gasto_id" name="tipo_gasto_id">
                <option value="">--SELECCIONE--</option>
                @foreach ($tiposGastos as $tipoGasto)
                    <option value="{{ $tipoGasto->id }}" {{ old('tipo_gasto_id',$contrato->tipo_gasto_id) == $tipoGasto->id ? 'selected' : '' }}>{{ $tipoGasto->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12 col-sm-12">
        <div class="form-group">
            <label for="objeto_contratacion">Objeto de la Contratación <span class="text-danger">(*)</span></label>
            <textarea name="objeto_contratacion" id="objeto_contratacion" class="form-control @error('objeto_contratacion') error @enderror" cols="30" rows="2">{{ old('objeto_contratacion') ?? $contrato->objeto_contratacion }}</textarea>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-5 col-sm-12">
        <div class="form-group">
            <label for="normativa_id">Normativa Aplicable <span class="text-danger">(*)</span></label>
            <select name="normativa_id" class="form-control select2 @error('normativa_id') error @enderror" id="normativa_id">
                <option value="">--SELECCIONE--</option>
                @foreach ($normativas as $normativa)
                    <option value="{{ $normativa->id }}" {{ old('normativa_id',$contrato->normativa_id) == $normativa->id ? 'selected' : '' }}>{{ $normativa->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="col-md-5 col-sm-12">
        <div class="form-group">
            <label for="modalidad_id">Modalidad del Proceso <span class="text-danger">(*)</span></label>
            <select name="modalidad_id" class="form-control select2 @error('modalidad_id') error @enderror" id="modalidad_id">
                <option value="">--SELECCIONE--</option>
                @foreach ($modalidades as $modalidad)
                    <option value="{{ $modalidad->id }}" {{ old('modalidad_id',$contrato->modalidad_id) == $modalidad->id ? 'selected' : '' }}>{{ $modalidad->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="precio_referencial">Precio Referencial <span class="text-danger">(*)</span></label>
            <input type="number" step="0.01" name="precio_referencial" id="precio_referencial" class="form-control @error('precio_referencial') error @enderror" value="{{ old('precio_referencial') ?? $contrato->precio_referencial }}">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="fuente_organismo">Fuente / Organismo</label>
            <input type="number" name="fuente_organismo" id="fuente_organismo" class="form-control @error('fuente_organismo') error @enderror" value="{{ old('fuente_organismo') ?? $contrato->fuente_organismo }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="numero_certificacion">N° Certificación</label>
            <input type="number" name="numero_certificacion" id="numero_certificacion" class="form-control @error('numero_certificacion') error @enderror" value="{{ old('numero_certificacion') ?? $contrato->numero_certificacion }}">
        </div>
    </div>

    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="fecha_autorizacion_inicio_proceso">Fecha Autorización Incio Proceso</label>
            <input type="date" name="fecha_autorizacion_inicio_proceso" id="fecha_autorizacion_inicio_proceso" class="form-control @error('fecha_autorizacion_inicio_proceso') error @enderror" value="{{ old('fecha_autorizacion_inicio_proceso') ?? $contrato->fecha_autorizacion_inicio_proceso ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="nro_resolucion_autorizacion">N° Resolución de Autorización</label>
            <input type="number" name="nro_resolucion_autorizacion" id="nro_resolucion_autorizacion" class="form-control @error('nro_resolucion_autorizacion') error @enderror" value="{{ old('nro_resolucion_autorizacion') ?? $contrato->nro_resolucion_autorizacion }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="fecha_resolucion_autorizacion">Fecha de Resolución de Autorización</label>
            <input type="date" name="fecha_resolucion_autorizacion" id="fecha_resolucion_autorizacion" class="form-control @error('fecha_resolucion_autorizacion') error @enderror" value="{{ old('fecha_resolucion_autorizacion') ?? $contrato->fecha_resolucion_autorizacion ?? '' }}">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="fecha_carta_adjudicacion">Fecha Elaboración carta de Adjudicación</label>
            <input type="date" name="fecha_carta_adjudicacion" id="fecha_carta_adjudicacion" class="form-control @error('fecha_carta_adjudicacion') error @enderror" value="{{ old('fecha_carta_adjudicacion') ?? $contrato->fecha_carta_adjudicacion ?? '' }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="fecha_notificacion_adjudicacion">Fecha Notificación carta de Adjudicación</label>
            <input type="date" name="fecha_notificacion_adjudicacion" id="fecha_notificacion_adjudicacion" class="form-control @error('fecha_notificacion_adjudicacion') error @enderror" value="{{ old('fecha_notificacion_adjudicacion') ?? $contrato->fecha_notificacion_adjudicacion ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="monto_adjudicado">Monto Adjudicado (Bs)</label>
            <input type="number" step="0.01" name="monto_adjudicado" id="monto_adjudicado" class="form-control @error('monto_adjudicado') error @enderror" value="{{ old('monto_adjudicado') ?? $contrato->monto_adjudicado }}">
        </div>
    </div>
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="empresa_adjudicada_id">Empresa Adjudicada</label>
            <select name="empresa_adjudicada_id" id="empresa_adjudicada_id" class="form-control select2 @error('empresa_adjudicada_id') error @enderror">
                <option value="">--SELECCIONE--</option>
                @foreach ($empresas as $empresa)
                    <option value="{{ $empresa->id }}" {{ old('empresa_adjudicada_id',$contrato->empresa_adjudicada_id) == $empresa->id ? 'selected' : '' }}>{{ $empresa->nombre }}</option>
                @endforeach
            </select>
            <button type="button" class="btn btn-rounded btn-info" data-toggle="modal" data-target="#modal-empresa">Agregar Empresa</button>
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="fecha_remision_juridica">Fecha de Remisión Jurídica</label>
            <input type="date" name="fecha_remision_juridica" id="fecha_remision_juridica" class="form-control @error('fecha_remision_juridica') error @enderror " value="{{ old('fecha_remision_juridica') ?? $contrato->fecha_remision_juridica ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="fecha_retorno_juridica">Fecha de Retorno Jurídica</label>
            <input type="date" name="fecha_retorno_juridica" id="fecha_retorno_juridica" class="form-control @error('fecha_retorno_juridica') error @enderror" value="{{ old('fecha_retorno_juridica') ?? $contrato->fecha_retorno_juridica ?? '' }}">
        </div>
    </div>

    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="tipo_contrato">Contrato - Orden de Compra / Servicio</label>
            <input type="text" name="tipo_contrato" id="tipo_contrato" class="form-control @error('tipo_contrato') error @enderror" value="{{ old('tipo_contrato') ?? $contrato->tipo_contrato ?? '' }}">
        </div>
    </div>
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="empresa_contratada_id">Empresa Contratada</label>
            <select name="empresa_contratada_id" id="empresa_contratada_id" class="form-control select2 @error('empresa_contratada_id') error @enderror">
                <option value="">--SELECCIONE--</option>
                @foreach ($empresas as $empresa)
                    <option value="{{ $empresa->id }}" {{ old('empresa_contratada_id',$contrato->empresa_contratada_id) == $empresa->id ? 'selected' : '' }}>{{ $empresa->nombre }}</option>
                @endforeach
            </select>
            <button type="button" class="btn btn-rounded btn-info" data-toggle="modal" data-target="#modal-empresa">Agregar Empresa</button>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="fecha_contrato">Fecha de Contrato</label>
            <input type="date" name="fecha_contrato" id="fecha_contrato" class="form-control @error('fecha_contrato') error @enderror" value="{{ old('fecha_contrato') ?? $contrato->fecha_contrato ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="monto_contrato">Monto del Contrato</label>
            <input type="number" step="0.01" name="monto_contrato" id="monto_contrato" class="form-control @error('monto_contrato') error @enderror" value="{{ old('monto_contrato') ?? $contrato->monto_contrato }}">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="plazo_entrega">Plazo de Entrega</label>
            <input type="text" name="plazo_entrega" id="plazo_entrega" class="form-control @error('plazo_entrega') error @enderror" value="{{ old('plazo_entrega') ?? $contrato->plazo_entrega }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="fecha_estimada_entrega">Fecha estimada de entrega</label>
            <input type="date" name="fecha_estimada_entrega" id="fecha_estimada_entrega" class="form-control @error('fecha_estimada_entrega') error @enderror" value="{{ old('fecha_estimada_entrega') ?? $contrato->fecha_estimada_entrega ?? '' }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="cuce">CUCE</label>
            <input type="text" name="cuce" id="cuce" class="form-control @error('cuce') error @enderror" value="{{ old('cuce') ?? $contrato->cuce }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="registro_contraloria">Registro Contraloria</label>
            <input type="text" name="registro_contraloria" id="registro_contraloria" class="form-control @error('registro_contraloria') error @enderror" value="{{ old('registro_contraloria') ?? $contrato->registro_contraloria }}">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="fecha_informe_conformidad">Fecha informe conformidad</label>
            <input type="date" name="fecha_informe_conformidad" id="fecha_informe_conformidad" class="form-control @error('fecha_informe_conformidad') error @enderror" value="{{ old('fecha_informe_conformidad') ?? $contrato->fecha_informe_conformidad ?? '' }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="fecha_registro_sicoes">Fecha registro sicoes</label>
            <input type="date" name="fecha_registro_sicoes" id="fecha_registro_sicoes" class="form-control @error('fecha_registro_sicoes') error @enderror" value="{{ old('fecha_registro_sicoes') ?? $contrato->fecha_registro_sicoes ?? '' }}">
        </div>
    </div>
    <div class="col-md-6 col-sm-12">
        <div class="form-group">
            <label for="situacion_proceso">Situación del Proceso</label>
            <input type="text" name="situacion_proceso" id="situacion_proceso" class="form-control @error('situacion_proceso') error @enderror" value="{{ old('situacion_proceso') ?? $contrato->situacion_proceso ?? '' }}">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="fecha_resimision_pago">Fecha de Resimisión de Pago</label>
            <input type="date" name="fecha_resimision_pago" id="fecha_resimision_pago" class="form-control @error('fecha_remision_pago') error @enderror" value="{{ old('fecha_resimision_pago') ?? $contrato->fecha_resimision_pago ?? '' }}">
        </div>
    </div>
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="recurrentes">Recurrentes</label> <br>
            <select name="recurrentes" id="recurrentes" class="form-control">
                <option value="">--SELECCIONE--</option>
                <option value="SI" {{ old('recurrentes',$contrato->recurrentes) == 'SI' ? 'selected' : '' }}>SI</option>
                <option value="NO" {{ old('recurrentes',$contrato->recurrentes) == 'NO' ? 'selected' : '' }}>NO</option>
            </select>
        </div>
    </div>
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="tipo_adjunto_id">Tipo de Adjunto</label>
            <select name="tipo_adjunto_id" id="tipo_adjunto_id" class="form-control">
                <option value="">--SELECCIONE--</option>
                @foreach ($tiposAdjuntos as $tipo)
                    <option value="{{ $tipo->id }}" {{ old('tipo_adjunto_id',$contrato->tipo_adjunto_id) == $tipo->id ? 'selected' : '' }}>{{ $tipo->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    
</div>
<div class="text-center mt-3">
    <button type="button" id="btnGuardarContrato" class="btn btn-rounded btn-{{ $color }}">{{ $texto }}</button>
    <a href="{{ route('contratos.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>