<div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Procesos de Contratación registrados</h4>
                    @can('contratos.create')
                        <a href="{{ route('procesos-contratacion.create') }}" class="btn btn-primary btn-round">Registrar Nuevo</a>
                    @endcan
                </div>
                <div class="card-body">
                    <p>Filtros de Busqueda</p>
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <input type="text" class="form-control" placeholder="Buscar por NURI o Código" wire:model.live="search">
                        </div>
                        <div class="col-md-3">
                            <input type="text" class="form-control" placeholder="Buscar por Objeto de Contratación" wire:model.live="searchObjetoContratacion">
                        </div>
                        <div class="col-md-3">
                            <select class="form-control" wire:model.live="filtroEntidad">
                                <option value="">Buscar por Entidad</option>
                                @foreach($entidades as $entidad)
                                    <option value="{{ $entidad->id }}">{{ $entidad->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select class="form-control" wire:model.live="filtroAsignado">
                                <option value="">Buscar por Técnico Asignado</option>
                                @foreach($asignados as $asignado)
                                    <option value="{{ $asignado->id }}">{{ $asignado->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    
                        <div class="col-md-2">
                            <select class="form-control" wire:model.live="filtroEstado">
                                <option value="">Buscar por Estado</option>
                                @foreach($estados as $estado)
                                    <option value="{{ $estado->id }}">{{ $estado->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="mb-2">
                        @if($search)
                            <span class="badge badge-info">
                                Código/NURI: "{{ $search }}"
                                <a href="#" wire:click.prevent="$set('search', '')" class="text-white ml-1">✖</a>
                            </span>
                        @endif

                        @if($searchObjetoContratacion)
                            <span class="badge badge-info">
                                Objeto: "{{ $searchObjetoContratacion }}"
                                <a href="#" wire:click.prevent="$set('searchObjetoContratacion', '')" class="text-white ml-1">✖</a>
                            </span>
                        @endif

                        @if($filtroEntidad)
                            <span class="badge badge-info">
                                Entidad: {{ $entidades->find($filtroEntidad)?->nombre }}
                                <a href="#" wire:click.prevent="$set('filtroEntidad', '')" class="text-white ml-1">✖</a>
                            </span>
                        @endif

                        @if($filtroAsignado)
                            <span class="badge badge-info">
                                Técnico: {{ $asignados->find($filtroAsignado)?->name }}
                                <a href="#" wire:click.prevent="$set('filtroAsignado', '')" class="text-white ml-1">✖</a>
                            </span>
                        @endif

                        @if($filtroEstado)
                            <span class="badge badge-info">
                                Estado: {{ $estados->find($filtroEstado)?->nombre }}
                                <a href="#" wire:click.prevent="$set('filtroEstado', '')" class="text-white ml-1">✖</a>
                            </span>
                        @endif

                        @if($search || $searchObjetoContratacion || $filtroEntidad || $filtroAsignado || $filtroEstado)
                            <button wire:click="resetFiltros" class="btn btn-sm btn-outline-danger ml-2">Limpiar todos</button>
                        @endif
                    </div>

                    <h4>Listado de Contratos </h4>
                    <div class="table-responsive">
                        <table class="table table-hover" id="datos">
                            <thead>
                                <tr>
                                    <th class="text-center">ACCIONES</th>
                                    <th class="text-center">CODIGO</th>
                                    <th class="text-center">NURI</th>
                                    <th class="text-center">FECHA INGRESO</th>
                                    <th class="text-center">OBJETO CONTRATACIÓN</th>
                                    <th class="text-center">TECNICO ASIGNADO</th>
                                    <th class="text-center">UNIDAD SOLICITANTE</th>
                                    <th class="text-center">PRECIO REFERENCIAL</th>
                                    <th class="text-center">ESTADO ACTUAL</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($contratos as $contrato)
                                <tr>
                                    <td class="d-flex align-items-center justify-content-center">
                                            {{-- <div class="btn-group" role="group">
                                               <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">ACCIONES</button>
                                               <div class="dropdown-menu">
                                                   <a href="#" wire:click="$dispatch('abrir-modal-asignacion',{contratoId:{{  $contrato->id  }} })"
                                                       class="dropdown-item" title="Asignar Técnico">
                                                       Asignar Técnico
                                                   </a>
                                                   <a class="dropdown-item" href="{{ route('contratos.edit', $contrato->id) }}">Modificar Datos</a>
                                                   <a class="dropdown-item" href="{{ route('contratos.show', $contrato->id) }}">Ver Contrato</a>
                                                   <a class="dropdown-item" href="{{ route('contratos.destroy', $contrato->id) }}" onclick="onclick="confirmarEliminacion({{ $contrato->id }})">Eliminar Contrato</a>
                                                   <form id="form-eliminar-{{ $contrato->id }}" action="{{ route('contratos.destroy', $contrato->id) }}" method="POST" style="display: none;">
                                                       @csrf
                                                       @method('DELETE')
                                                   </form>
                                               </div>
                                           </div> --}}
                                            
                                            <a href="{{ route('contratos.edit', $contrato->id) }}" class="btn btn-sm btn-outline-warning" title="Modificar datos del Contrato"><i class="fa fa-edit"></i></a>
                                            
                                            <a href="{{ route('contratos.show', $contrato->id) }}" class="btn btn-sm btn-outline-info" title="Ver Contrato" target="_blank"><i class="fa fa-file-pdf-o"></i></a>
                                            {{-- <a class="btn btn-sm btn-outline-danger" href="{{ route('contratos.destroy', $contrato->id) }}" onclick="onclick="confirmarEliminacion({{ $contrato->id }})"><i class="fa fa-trash"></i></a>
                                                <form id="form-eliminar-{{ $contrato->id }}" action="{{ route('contratos.destroy', $contrato->id) }}" method="POST" style="display: none;">
                                                    @csrf
                                                    @method('DELETE')
                                                </form> --}}
                                            <a href="javascript:void(0);" 
                                                class="btn btn-sm btn-outline-danger delete-btn"
                                                data-id="{{ $contrato->id }}" 
                                                title="Eliminar contrato">
                                                <i class="fa fa-trash"></i>
                                            </a>
                                            <a href="javascript:void(0);" wire:click="$dispatch('abrir-modal-asignacion',{contratoId:{{  $contrato->id  }} })"
                                                class="btn btn-sm btn-outline-secondary" title="Asignar Técnico">
                                                <i class="fa fa-user-plus"></i>
                                            </a>
                                            <a href="javascript:void(0);" wire:click="$dispatch('abrirModalSeguimiento',{contratoId:{{  $contrato->id  }} })" class="btn btn-sm btn-outline-success">
                                                <i class="fa fa-history"></i>
                                            </a>
                                        </td>
                                        <td class="text-center">{{ $contrato->codigo }}</td>
                                        <td class="text-center">{{ $contrato->nuri }}</td>
                                        <td class="text-center">{{ date('d/m/Y', strtotime($contrato->fecha_ingreso)) }}</td>
                                        <td>{{ $contrato->objeto_contratacion }}</td>
                                        <td class="text-center"> @if($contrato->ultimaAsignacion != null) <label for="" class="badge badge-rounded badge-primary">{{$contrato->ultimaAsignacion?->responsable?->name}}</label> @else <label for="" class="badge badge-rounded badge-danger">Sin Asignar</label> @endif</td>
                                        <td class="text-center">{{ $contrato->entidad->nombre }}</td>
                                        <td class="text-center">{{ number_format($contrato->precio_referencial,2) }}</td>
                                        <td class="text-center">@if($contrato->ultimoSeguimiento != null) {{ optional($contrato->ultimoSeguimiento)->estado->nombre }} <br> {{ date('d/m/Y', strtotime($contrato->ultimoSeguimiento->fecha_seguimiento)) }} @else <label for="" class="badge badge-rounded badge-success">Sin Seguimiento</label> @endif</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9">
                                            <div class="alert alert-danger alert-outline-primary mb-0" role="alert">
                                                No hay contratos registrados.
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        {{ $contratos->links() }}
                    </div> {{-- Stop trying to control. --}}
                </div>
            </div>
        </div>
    </div>
    <livewire:contratos.asignar-tecnico-modal />
    <livewire:contratos.seguimiento-modal />
    <form id="delete-form" method="POST" style="display:none;" >
        @csrf
        @method('DELETE')
    </form>
    @section('scripts')
        <script>
            Livewire.on('mostrar-modal-asignacion', () => {
                const modalA = new bootstrap.Modal(document.getElementById('modalAsignacion'));
                modalA.show();
            });
            
            Livewire.on('cerrar-modal-asignacion', () => {
                const modalA = bootstrap.Modal.getInstance(document.getElementById('modalAsignacion'));
                if (modalA) {
                    modalA.hide();
                }
            });

            Livewire.on('asignacion-exitosa', (data) => {
                Swal.fire({
                    icon: 'success',
                    title: 'Listo',
                    text: data.mensaje ?? 'Técnico asignado correctamente.',
                    timer: 2500,
                    showConfirmButton: false
                });
                Livewire.dispatch('cerrar-modal-asignacion');
            });

            Livewire.on('seguimiento-guardado', () => {
                Swal.fire({
                    icon: 'success',
                    title: 'Seguimiento guardado',
                    text: 'El seguimiento se ha guardado correctamente.',
                });
                
                // Usar Bootstrap 5 para cerrar
                Livewire.dispatch('cerrar-modal-seguimiento');
            });

            Livewire.on('mostrar-modal-seguimiento', () => {
                const modal = new bootstrap.Modal(document.getElementById('modalSeguimiento'));
                modal.show();
            });

            Livewire.on('cerrar-modal-seguimiento', () => {
                // alert('cerrar-modal-seguimiento');
                $('#modalSeguimiento').modal('hide');
                const modal = bootstrap.Modal.getInstance(document.getElementById('modalSeguimiento'));
                if (modal) {
                    modal.hide();
                } else {
                    // Si no hay instancia, intentar cerrar directamente
                    $('#modalSeguimiento').modal('hide');
                }
            });

        Livewire.on('confirmar-reemplazo', (data) => {
            Swal.fire({
                icon: 'warning',
                title: '¿Reemplazar técnico?',
                html: `
                    <p>Actualmente asignado: <strong>${data.actual}</strong></p>
                    <p>Nuevo técnico: <strong>${data.nuevo}</strong></p>
                    <p>¿Desea continuar?</p>
                `,
                showCancelButton: true,
                confirmButtonText: 'Sí, reemplazar',
                cancelButtonText: 'Cancelar',
            }).then((result) => {
                if (result.isConfirmed) {
                    // Llama a Livewire para guardar realmente
                    Livewire.dispatch('guardarAsignacion');
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.delete-btn').forEach(button => {
                button.addEventListener('click', function () {
                    const itemId = this.dataset.id;
    
                    Swal.fire({
                        title: '¿Está seguro de eliminar el contrato?',
                        text: "Esta acción no se puede deshacer.",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: "#3085d6",
                        cancelButtonColor: "#d33",
                        confirmButtonText: 'Sí, eliminar',
                        cancelButtonText: 'Cancelar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            const form = document.getElementById('delete-form');
                            form.action = baseUrl + `/contratos/${itemId}/eliminar`; // Asegúrate que coincida con tu ruta
                            form.submit();
                        }
                    });
                });
            });
        });

        
    </script>
    @endsection
</div>

