@extends('layouts.app')
@section('titulo','Parametros')
@section('content')
<div class="row page-titles mx-0 mb-2">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Gestión de parametros</h4>
            <span class="ml-1">Valores que se muestran en los formularios</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Configuraciones</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Parámetros</a></li>
        </ol>
    </div>
</div>
<!-- row -->
<div class="row">
    <div class="col-xl-12 col-xxl-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title">Tipos de Parámetros Disponibles</h4>
                    
                </div>
            </div>
            <div class="card-body">
                <!-- Filtros -->
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label for="filtro-tipo" class="form-label">Seleccionar Tipo:</label>
                        <select id="filtro-tipo" class="form-control">
                            <option value="">Seleccione un tipo</option>
                            @foreach($tipos as $tipo)
                                <option value="{{ $tipo }}">{{ ucfirst($tipo) }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="nuevo-tipo" class="form-label">O Crear nuevo tipo:</label>
                        <input type="text" id="nuevo-tipo" class="form-control" placeholder="Ingrese nuevo tipo" onkeyup="javascript:this.value=this.value.toUpperCase();">
                    </div>
                     <div class="col-md-4">
                        <br>
                            <button id="btn-agregar" class="btn btn-primary" disabled>
                                <i class="fa fa-plus"></i> Agregar Parámetro
                            </button>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover" id="tabla-parametros">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">ID</th>
                                <th class="text-center">Tipo</th>
                                <th class="text-center">Nombre</th>
                                <th class="text-center">Fecha Creación</th>
                            </tr>
                        </thead>
                        <tbody id="tbody-parametros">
                            <tr>
                                <td colspan="5" class="text-center">Seleccione un tipo para ver los parámetros</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@include('parametros._modal')
@endsection
@section('scripts')
<script>
$(document).ready(function() {
    let tipoSeleccionado = '';
    let modoEdicion = false;

    // Manejar cambio de tipo
    $('#filtro-tipo').change(function() {
        tipoSeleccionado = $(this).val();
        $('#nuevo-tipo').val('');
        actualizarEstadoBotones();
        if (tipoSeleccionado) {
            cargarParametrosPorTipo(tipoSeleccionado);
        } else {
            limpiarTabla();
        }
    });

    // Manejar nuevo tipo
    $('#nuevo-tipo').on('input', function() {
        const nuevoTipo = $(this).val().trim();
        if (nuevoTipo) {
            $('#filtro-tipo').val('');
            tipoSeleccionado = nuevoTipo;
            limpiarTabla();
        } else {
            tipoSeleccionado = '';
        }
        actualizarEstadoBotones();
    });

    // Función para actualizar estado de botones
    function actualizarEstadoBotones() {
        $('#btn-agregar').prop('disabled', !tipoSeleccionado);
    }

    // Cargar parámetros por tipo
    function cargarParametrosPorTipo(tipo) {
        $.ajax({
            url: '{{ route("parametros.get-by-tipo") }}',
            type: 'GET',
            data: { tipo: tipo },
            success: function(response) {
                if (response.success) {
                    mostrarParametros(response.data);
                } else {
                    Swal.fire('Error', response.message, 'error');
                }
            },
            error: function() {
                Swal.fire('Error', 'Error al cargar los parámetros', 'error');
            }
        });
    }

    // Mostrar parámetros en la tabla
    function mostrarParametros(parametros) {
        const tbody = $('#tbody-parametros');
        tbody.empty();

        if (parametros.length === 0) {
            tbody.append('<tr><td colspan="5" class="text-center">No hay parámetros para este tipo</td></tr>');
            return;
        }

        parametros.forEach(function(parametro) {
            const fecha = new Date(parametro.created_at).toLocaleDateString();
            const tipo = parametro.tipo.charAt(0).toUpperCase() + parametro.tipo.slice(1);
            const fila = `
                <tr>
                    <td class="text-center">
                        <button class="btn btn-sm btn-outline-warning btn-editar" title="Editar Parámetro" data-id="${parametro.id}">
                            <i class="fa fa-edit"></i>
                        </button>
                        <button class="btn btn-sm btn-outline-danger btn-eliminar" title="Eliminar Parámetro" data-id="${parametro.id}">
                            <i class="fa fa-trash"></i>
                    </td>
                    <td class="text-center">${parametro.id}</td>
                    <td class="text-center">${tipo}</td>
                    <td class="text-center">${parametro.nombre}</td>
                    <td class="text-center">${fecha}</td>
                </tr>
            `;
            tbody.append(fila);
        });
    }

    // Limpiar tabla
    function limpiarTabla() {
        $('#tbody-parametros').html('<tr><td colspan="5" class="text-center">Seleccione un tipo para ver los parámetros</td></tr>');
    }

    // Agregar parámetro
    $('#btn-agregar').click(function() {
        abrirModal('agregar');
    });

    // Editar parámetro
    $(document).on('click', '.btn-editar', function() {
        const id = $(this).data('id');
        editarParametro(id);
    });

    // Eliminar parámetro
    $(document).on('click', '.btn-eliminar', function() {
        const id = $(this).data('id');
        eliminarParametro(id);
    });

    // Abrir modal
    function abrirModal(modo, parametro = null) {
        modoEdicion = modo === 'editar';
        
        if (modoEdicion) {
            $('#modal-parametro-label').text('EDITAR PARÁMETRO');
            $('#parametro-id').val(parametro.id);
            $('#parametro-tipo').val(parametro.tipo);
            $('#parametro-nombre').val(parametro.nombre);
        } else {
            $('#modal-parametro-label').text('AGREGAR PARÁMETRO');
            $('#form-parametro')[0].reset();
            $('#parametro-tipo').val(tipoSeleccionado);
        }
        
        $('#modal-parametro').modal('show');
    }

    // Editar parámetro
    function editarParametro(id) {
        $.ajax({
            url: baseUrl + `/parametros/${id}`,
            type: 'GET',
            success: function(response) {
                if (response.success) {
                    abrirModal('editar', response.data);
                } else {
                    Swal.fire('Error', response.message, 'error');
                }
            },
            error: function() {
                Swal.fire('Error', 'Error al cargar el parámetro', 'error');
            }
        });
    }

    // Eliminar parámetro
    function eliminarParametro(id) {
        Swal.fire({
            title: '¿Está seguro de eliminar el parámetro?',
            text: "Esta acción no se puede deshacer",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: baseUrl + `/parametros/${id}`,
                    type: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire('Eliminado', response.message, 'success');
                            cargarParametrosPorTipo(tipoSeleccionado);
                        } else {
                            Swal.fire('Error', response.message, 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error', 'Error al eliminar el parámetro', 'error');
                    }
                });
            }
        });
    }

    // Guardar parámetro
    $('#form-parametro').submit(function(e) {
        e.preventDefault();
        
        const formData = {
            tipo: $('#parametro-tipo').val(),
            nombre: $('#parametro-nombre').val()
        };

        const url = modoEdicion ? 
            baseUrl + `/parametros/${$('#parametro-id').val()}` : 
            '{{ route("parametros.store") }}';
        
        const method = modoEdicion ? 'PUT' : 'POST';

        Swal.fire({
            title: modoEdicion ? '¿Guardar cambios?' : '¿Agregar parámetro?',
            text: modoEdicion ? 
                'Se actualizará el parámetro con los nuevos datos' : 
                'Se agregará un nuevo parámetro',
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, guardar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: url,
                    type: method,
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire('Éxito', response.message, 'success');
                            $('#modal-parametro').modal('hide');
                            cargarParametrosPorTipo(tipoSeleccionado);
                            
                            // Si es un nuevo tipo, actualizar la lista
                            if (!modoEdicion && !$('#filtro-tipo option[value="' + tipoSeleccionado + '"]').length) {
                                $('#filtro-tipo').append(`<option value="${tipoSeleccionado}">${tipoSeleccionado}</option>`);
                            }
                        } else {
                            Swal.fire('Error', response.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        const errors = xhr.responseJSON?.errors;
                        if (errors) {
                            let errorMessage = '';
                            Object.values(errors).forEach(function(error) {
                                errorMessage += error[0] + '<br>';
                            });
                            Swal.fire('Error de validación', errorMessage, 'error');
                        } else {
                            Swal.fire('Error', 'Error al guardar el parámetro', 'error');
                        }
                    }
                });
            }
        });
    });
});
</script>
@endsection