<div>
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Seguimientos registrados para los contratos</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <label>Contrato</label>
                            <select wire:model.live="contrato_id" class="form-control">
                                <option value="">Todos</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $contratos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($c->id); ?>"><?php echo e($c->codigo); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Estado</label>
                            <select wire:model.live="estado_id" class="form-control">
                                <option value="">Todos</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $estados_seguimiento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($e->id); ?>"><?php echo e($e->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Técnico</label>
                            <select wire:model.live="tecnico_id" class="form-control">
                                <option value="">Todos</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $tecnicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($t->id); ?>"><?php echo e($t->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Fecha</label>
                            <div class="d-flex">
                                <input wire:model.live="fecha_inicio" type="date" class="form-control me-2">
                                <input wire:model.live="fecha_fin" type="date" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="text-right mb-2">
                        <!--[if BLOCK]><![endif]--><?php if($contrato_id || $estado_id || $tecnico_id || $fecha_inicio || $fecha_fin): ?>
                            <strong class="text-primary">Filtros aplicados:</strong>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($contrato_id): ?>
                            <span class="badge badge-outline-secondary ">
                                Contrato: <?php echo e($contratos->find($contrato_id)?->nombre); ?>

                                <a href="#" wire:click.prevent="$set('contrato_id', '')" class="text-white ms-1">✖</a>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($estado_id): ?>
                            <span class="badge badge-outline-secondary ">
                                Estado: <?php echo e($estados_seguimiento->find($estado_id)?->nombre); ?>

                                <a href="#" wire:click.prevent="$set('estado_id', '')" class="text-white ms-1">✖</a>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($tecnico_id): ?>
                            <span class="badge badge-outline-secondary ">
                                Técnico: <?php echo e($tecnicos->find($tecnico_id)?->name); ?>

                                <a href="#" wire:click.prevent="$set('tecnico_id', '')" class="text-white ms-1">✖</a>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($fecha_inicio || $fecha_fin): ?>
                            <span class="badge badge-outline-secondary ">
                                Fecha: <?php echo e($fecha_inicio ? \Carbon\Carbon::parse($fecha_inicio)->format('d/m/Y') : '...'); ?> -
                                    <?php echo e($fecha_fin ? \Carbon\Carbon::parse($fecha_fin)->format('d/m/Y') : '...'); ?>

                                <a href="#" wire:click.prevent="resetFechas" class="text-white ms-1">✖</a>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($contrato_id || $estado_id || $tecnico_id || $fecha_inicio || $fecha_fin): ?>
                            <button wire:click="resetFiltros" class="btn btn-sm btn-outline-danger ms-2">Limpiar todos</button>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Fecha</th>
                                <th class="text-center">Estado</th>
                                <th class="text-center">Contrato</th>
                                <th class="text-center">Registrado por</th>
                                <th class="text-center">Observación</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $seguimientos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-outline-primary" wire:click="editar(<?php echo e($s->id); ?>)"><i class="fa fa-edit"></i></button>
                                        <button class="btn btn-sm btn-outline-danger" onclick="eliminarConfirmado(<?php echo e($s->id); ?>)"><i class="fa fa-trash"></i></button>
                                    </td>
                                    <td class="text-center"><?php echo e(date('d/m/Y', strtotime($s->fecha_seguimiento))); ?></td>
                                    <td class="text-center"><?php echo e($s->estado->nombre ?? ''); ?></td>
                                    <td class="text-center"><?php echo e($s->contrato->codigo ?? 'N/A'); ?></td>
                                    <td class="text-center"><?php echo e($s->tecnico->name ?? ''); ?></td>
                                    <td><?php echo e($s->observacion); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>

                    <?php echo e($seguimientos->links('pagination::bootstrap-4')); ?>


                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('contratos.seguimiento-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1372493989-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                </div>
            </div>
        </div>
    </div>
    
</div>

<?php $__env->startSection('scripts'); ?>
<script>
    window.eliminarConfirmado = function (id) {
        Swal.fire({
            title: '¿Está seguro?',
            text: "Esto eliminará el seguimiento.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar'
        }).then((result) => {
            if (result.isConfirmed) {
                Livewire.dispatch('eliminar', { id });
            }
        });
    }

    Livewire.on('alerta', ({ text }) => {
        Swal.fire('Correcto', text, 'success');
    });

    Livewire.on('abrir-modal', () => {
        $('#modalSeguimiento').modal('show');
    });

    Livewire.on('cerrar-modal', () => {
        $('#modalSeguimiento').modal('hide');
    });
</script>
<?php $__env->stopSection(); ?>
<?php /**PATH C:\laragon\www\contrataciones\resources\views/livewire/seguimientos-component.blade.php ENDPATH**/ ?>