
<?php $__env->startSection('titulo','Nuevo Contrato'); ?>
<?php $__env->startSection('content'); ?>
<div class="row page-titles mx-0 mb-2">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Registro de Nuevo Contrato</h4>
            <span class="ml-1">Agregar un nuevo contrato a la base de datos</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Contratos</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Nuevo</a></li>
        </ol>
    </div>
</div>
<!-- row -->
<div class="row">
    <div class="col-xl-12 col-xxl-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Datos Generales</h4>
            </div>
            <div class="card-body">
                <?php echo Form::open(['route'=>'contratos.store','class'=>'form-horizontal','id'=>'formContrato']); ?>

                    <?php echo $__env->make('contratos._form',['texto' => 'Registrar','color'=>'primary'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('contratos._modal_empresa', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/empresas.js')); ?>"></script>
    <script>
         $(".select2").select2();
    </script>
    <script>
        document.getElementById('btnGuardarContrato').addEventListener('click', function () {
            const form = document.getElementById('formContrato');
            const responsableId = document.getElementById('responsable_id').value;

            if (responsableId) {
                Swal.fire({
                    title: '¿Asignar nuevo técnico?',
                    text: "Se cambiará el técnico asignado al contrato.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sí, asignar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    } else {
                        document.getElementById('responsable_id').value = '';
                        form.submit();
                    }
                });
            } else {
                form.submit();
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\contrataciones\resources\views/contratos/create.blade.php ENDPATH**/ ?>