<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('unidads', function (Blueprint $table) {
            $table->id();
            $table->string('codigo')->nullable();
            $table->string('nombre');
            $table->string('logo')->nullable();
            $table->string('region')->nullable();
            $table->boolean('intranet')->default(0)->comment('1 = Ver Intranet de la unidad, 0 = No ver Intranet de la unidad');
            $table->integer('tipo')->nullable()->comment('1 = Area, 2 = Unidad');
            $table->unsignedBigInteger('area_id')->nullable()->comment('id de su id padre en la misma tabla');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('area_id')->references('id')->on('unidads');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('unidads');
    }
};
