<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contenido_paginas', function (Blueprint $table) {
            $table->id();
            $table->date('fecha');
            $table->string('titulo');
            $table->text('descripcion');
            $table->string('nro_resolucion')->nullable();
            $table->string('adjunto')->nullable()->comment('Puede ser imagen para noticias o anuncios, y documentos para otras áreas');
            $table->string('adjunto_nombre_original')->nullable();
            $table->string('adjunto_tipo')->nullable();
            $table->unsignedInteger('contenido_tipo_id')->nullable();
            $table->unsignedInteger('grupo_id')->nullable()->comment('Solo se utiliza para documentos internos');
            $table->unsignedInteger('unidad_id')->nullable();
            $table->unsignedInteger('menu_item_id');
            $table->boolean('estado')->default(0)->comment('1 = Publicado, 0 = No publicado');
            $table->integer('origen')->nullable()->comment('1 = Marca a los documentos migrados de la base de datos');
            $table->integer('visible')->default(1)->comment('1 = Visible para todos, 0 = Privado solo para la unidad asignada');
            $table->foreign('unidad_id')->references('id')->on('unidads');
            $table->foreign('menu_item_id')->references('id')->on('menu_items');
            $table->foreign('grupo_id')->references('id')->on('clasificadors');
            $table->foreign('contenido_tipo_id')->references('id')->on('clasificadors');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contenido_paginas');
    }
};
