<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //PERMISOS PARA VER LA SECCIONES DEL INTRANET SIEMPRE DEBEN TENER ASIGNADOS TODOS LOS ROLES
        //'noticias.show',
        // 'eventos.show', directorio.show            
        // 'documentos_internos.show',
        // 'capacitaciones.show',
        // 'documentos_generales.show',
        // 'sociales.show',
        // 'sistemas_sedem.show',
        // 'sitios_web.show'
        
        Role::create(['name'=>'superadmin', 'descripcion'=> 'Super Administrador']);
        Role::create(['name'=>'Administrador','descripcion'=>'Administrador del sistema'])->syncPermissions([
            'noticias.show','eventos.show','directorio.show','documentos_internos.show','capacitaciones.show','documentos_generales.show','sociales.show','sistemas_sedem.show','sitios_web.show',
            'users.index','users.create','users.edit','users.destroy','users.show',
            'roles.index','roles.show','roles.create','roles.edit',
            'menus.index','menus.create','menus.edit','menus.destroy',
            'contenidos.index','contenidos.create','contenidos.edit','contenidos.destroy',
            'eventos.index','eventos.create','eventos.edit','eventos.destroy',
            'directorio_empleados.index','directorio_empleados.create','directorio_empleados.edit','directorio_empleados.destroy',
            'areas.index','areas.create','areas.edit','areas.destroy',
            'unidades.index','unidades.create','unidades.edit','unidades.destroy',
            'empleados.index','empleados.create','empleados.edit','empleados.destroy',
            'tipo_contenidos.index','tipo_contenidos.create','tipo_contenidos.edit','tipo_contenidos.destroy',
            'grupos.index','grupos.create','grupos.edit','grupos.destroy'
        ]);
        Role::create(['name'=>'Administrador de Área','descripcion'=>'Administrador del intranet de un área institucional'])->syncPermissions([
            'noticias.show','eventos.show','directorio.show','documentos_internos.show','capacitaciones.show','documentos_generales.show','sociales.show','sistemas_sedem.show','sitios_web.show',
            'users.index','users.create','users.edit','users.destroy','users.show',
            'noticias.index','noticias.create','noticias.edit','noticias.destroy',
            'eventos.index','eventos.create','eventos.edit','eventos.destroy',
            'directorio_empleados.index','directorio_empleados.create','directorio_empleados.edit','directorio_empleados.destroy',
            'documentos_internos.index','documentos_internos.create','documentos_internos.edit','documentos_internos.destroy',
            'capacitaciones.index','capacitaciones.create','capacitaciones.edit','capacitaciones.destroy',
            'documentos_generales.index','documentos_generales.create','documentos_generales.edit','documentos_generales.destroy',
            'sociales.index','sociales.create','sociales.edit','sociales.destroy',
            'sitios_web.index','sitios_web.create','sitios_web.edit','sitios_web.destroy',
            'empleados.index','empleados.create','empleados.edit','empleados.destroy',
            'tipo_contenidos.index','tipo_contenidos.create','tipo_contenidos.edit','tipo_contenidos.destroy',
            'grupos.index','grupos.create','grupos.edit','grupos.destroy'
        ]);
        Role::create(['name'=>'Administrador de Unidad','descripcion'=>'Administrador del intranet de una unidad institucional'])->syncPermissions([
            'noticias.show','eventos.show','directorio.show','documentos_internos.show','capacitaciones.show','documentos_generales.show','sociales.show','sistemas_sedem.show','sitios_web.show',
            'users.index','users.create','users.edit','users.destroy','users.show',
            'noticias.index','noticias.create','noticias.edit','noticias.destroy',
            'eventos.index','eventos.create','eventos.edit','eventos.destroy',
            'directorio_empleados.index','directorio_empleados.create','directorio_empleados.edit','directorio_empleados.destroy',
            'documentos_internos.index','documentos_internos.create','documentos_internos.edit','documentos_internos.destroy',
            'capacitaciones.index','capacitaciones.create','capacitaciones.edit','capacitaciones.destroy',
            'documentos_generales.index','documentos_generales.create','documentos_generales.edit','documentos_generales.destroy',
            'sociales.index','sociales.create','sociales.edit','sociales.destroy',
            'sitios_web.index','sitios_web.create','sitios_web.edit','sitios_web.destroy',
            'empleados.index','empleados.create','empleados.edit','empleados.destroy',
            'tipo_contenidos.index','tipo_contenidos.create','tipo_contenidos.edit','tipo_contenidos.destroy',
            'grupos.index','grupos.create','grupos.edit','grupos.destroy'
        ]);
        Role::create(['name'=>'Funcionario','descripcion'=>'Personal de la institución'])->syncPermissions([
            'noticias.show',
            'eventos.show',  
            'directorio.show',          
            'documentos_internos.show',
            'capacitaciones.show',
            'documentos_generales.show',
            'sociales.show',
            'sistemas_sedem.show',
            'sitios_web.show','users.show',
        ]);
    }
}
