 
var adminUrl=url_global;
var _modal = $('#nuevoTipoContenido');
var btnSave = $('.btnSave');
var btnUpdate = $('.btnUpdate');
var csrf = $('input[name="_token"]').val();
var cadena_eliminar='';
var cadena_editar='';
var cadena='';

$.ajaxSetup({
    headers: {'X-CSRF-Token': csrf}
});
$.fn.dataTable.Api.register('column().searchable()', function() {
    var ctx = this.context[0];
    return ctx.aoColumns[this[0]].bSearchable;
});
function createDropdowns(api) {
    api.columns().every(function() {
        if (this.searchable()) {
            var that = this;
            var col = this.index();

            // Only create if not there or blank
            var selected = $('thead tr:eq(1) td:eq(' + col + ') tipoFiltro').val();
            if (selected === undefined || selected === '' ) {
                // Create the `select` element
                $('thead tr:eq(1) td')
                    .eq(col)
                    .empty();
                var select = $('<select class="form-control tipoFiltro" ><option value=""></option></select>')
                    .appendTo($('thead tr:eq(1) td').eq(col))
                    .on('change', function() {
                        that.search($(this).val()).draw();
                        createDropdowns(api);
                    });

                api
                    .cells(null, col, {
                        search: 'applied'
                    })
                    .data()
                    .sort()
                    .unique()
                    .each(function(d) {
                        select.append($('<option>' + d + '</option>'));
                    });
            }
        }
    });
}

function getRecords() {
    $.getJSON(adminUrl + '/listar_tipo_contenidos', function (json) {
        var data = json.map(function (fila) {
            if(d){
                cadena_eliminar='<button type="button" class="btn btn-danger btn-icon btn-round btnDelete"  data-id="' + fila.id + '" title="Eliminar registro"><i class="fas fa-trash-alt"></i></button>';
            }
            if(e){
                cadena_editar='<button type="button" class="btn btn-warning btn-icon btn-round btnEdit" data-id="' + fila.id + '" title="Modificar datos registro" ><i class="fas fa-edit"></i></button>';
            }
            cadena=cadena_editar+cadena_eliminar;
        return $.extend({ boton: cadena}, fila);
    });
    $('#datos').DataTable( {
            destroy:true,
            
            "language": {
                "processing": "Procesando...",
                "lengthMenu": 'Filtrar <select>'+
                    '<option value="10">10</option>'+
                    '<option value="20">20</option>'+
                    '<option value="30">30</option>'+
                    '<option value="40">40</option>'+
                    '<option value="50">50</option>'+
                    '<option value="-1">Todos</option>'+
                    '</select> Registros',
                "paginate": {
                    "previous": '<i class="fa fa-angle-left"></i>',
                    "next": '<i class="fa fa-angle-right"></i>'
                },
                "info": "Pagina _PAGE_ de _PAGES_",
                "search": "Busqueda Gral.:",
                "emptyTable": "No existen datos registrados.",
                "infoEmpty": "",
            },
            fixedHeader: true,
            orderCellsTop: true,
            data: data,
            columnDefs: [
                {
                    searchable: false,
                    targets: [2], //que columna no sea filtrable
                }
            ],
            columns: [
                {  data: "nombre" },
                {  data: "menu.name",class:'text-left'},
                {  data: "boton",class:'text-center' },
            ],
            initComplete: function() {
                createDropdowns(this.api());
            }
        } );
    });
};

getRecords();

function reset() 
{
    _modal.find('input').each(function () 
    {
        $(this).val(null)
    })
    $('#menu_item_id').val('');
};


function getInputs() 
{
    var id_contenido = $('input[name="contenido_id"]').val();
    var nombre_contenido = $('input[name="nombre_contenido"]').val();
    var menu = $('#menu_item_id').val();
    var tipo='contenido';
    return {id: id_contenido, nombre: nombre_contenido,menu_item_id:menu,tipo:tipo};
};

_modal.on('shown.bs.modal', function () {
    $('#nombre_contenido').trigger('focus')
  })

function create() 
{ 
    _modal.find('.modal-title').text('Nuevo Tipo de Contenido');
    reset();
    _modal.modal('show')
    btnSave.show()
    btnUpdate.hide()
};


$(document).on('submit', '#storeTipoContenido', function(event) {
	event.preventDefault();
    var tipoID=$('input[name="contenido_id"]').val();
    Swal.fire({
        target: document.getElementById('nuevoTipoContenido'),
        title: 'Desea continuar?',
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'SI',
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'POST',
                url: adminUrl + '/tipo_contenidos/store',
                data:  getInputs(),
                dataType: 'JSON',
                success: function ()
                { 
                    reset(_modal);
                    _modal.modal('hide');
                    getRecords();
                    if(tipoID != ''){
                        Swal.fire({
                            title: "Actualizado!",
                            text: "Datos actualizados correctamente.",
                            icon: "success"
                          });
                    }
                    else{
                        Swal.fire({
                            title: "Registrado!",
                            text: "Tipo de contenido registrado correctamente.",
                            icon: "success"
                          });
                    }
                    $('#seccionDocumento').removeClass('has-error');
                    $('#seccionNombre').removeClass('has-error');
                },
                error: function (data) {
                    var e=data.responseJSON;
                    var errores=e.errors
                    var html='<ul class="list-ticked">';
                    Swal.fire({
                        title: "Error!",
                        text: "Debe verificar los datos de entrada!!",
                        icon: "error"
                      });
                    if(errores.nombre != undefined){
                        html+='<li class="text-danger">'+e.errors.nombre+'</li>';
                        $('#seccionNombre').addClass('has-error');
                    }else{
                        $('#seccionNombre').removeClass('has-error');
                    }
                    if(errores.menu_item_id != undefined){
                        html+='<li class="text-danger">'+e.errors.menu_item_id+'</li>';
                        $('#seccionDocumento').addClass('has-error');
                    }
                    else{
                        $('#seccionDocumento').removeClass('has-error');
                    }
                    html+='</ul>';
                    $('#errores').html(html);
                }
            })
          
        }
      });
    
});

$('table').on('click', '.btnEdit', function ()
{ 
    var id = $(this).data('id');
    var nombre = $(this).parent().parent().find('td').eq(0).text()
    var menu = $(this).parent().parent().find('td').eq(1).text()
    _modal.find('.modal-title').text('MODIFICAR TIPO DE CONTENIDO')
    _modal.modal('show')
    console.log(menu);
    $('input[name="contenido_id"]').val(id);
    $('#nombre_contenido').val(nombre);
    $("#menu_item_id option").filter(function () {                                       
        return $(this).text() == menu;
     }).prop('selected', true);
    btnSave.hide()
    btnUpdate.show()

});


$('table').on('click', '.btnDelete', function () 
{
    var id = $(this).data('id');
    Swal.fire({
        title: 'Desea eliminar el Tipo de Contenido ?', // 'Desea continuar?',
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si, Eliminar!',
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'DELETE',
                url: adminUrl + '/tipo_contenidos/'+id,
                dataType: 'JSON',
                success: function ()
                { 
                    getRecords();
                    Swal.fire({
                        title: "Eliminado!",
                        text: "El registro fue eliminado correctamente.",
                        icon: "success"
                    });
                    
                },
            })
          
        }
      });   
});

