@if ($errors->any())
    <h5 class="text-danger">CORRIJA ESTOS ERRORES:</h5>
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<p>Debe rellenar todos los campos marcados con <span class="text-danger">(*)</span>.</p>
<div class="form-group">
    <label for="titulo">Título <span class="text-danger">(*)</span></label>
    <input type="text" name="titulo" class="form-control" value="{{ old('titulo',$comunicado->titulo) }}">
</div>

<div class="form-group">
    <label for="contenido">Contenido <span class="text-danger">(*)</span></label>
    <textarea name="contenido" class="form-control" >{{ old('contenido',$comunicado->contenido) }}</textarea>
</div>
{{-- <div class="form-group">
    <label for="archivo_respaldo">Documento de Respaldo:</label>
    <input type="file" name="archivo_respaldo" class="form-control" value="{{ old('archivo_respaldo',$comunicado->archivo_respaldo) }}">
</div> --}}

<div class="form-group">
    <label for="url">URL de apoyo (Si es documento la url del documento que ya este publicado):</label>
    <input type="text" name="url" class="form-control" value="{{ old('url',$comunicado->url) }}">
</div>
<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="fecha_inicio">Fecha de inicio <span class="text-danger">(*)</span></label>
            <input type="datetime-local" name="fecha_inicio" class="form-control" value="{{ old('fecha_inicio',$comunicado->fecha_inicio) }}">
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="fecha_fin">Fecha de fin <span class="text-danger">(*)</span></label>
            <input type="datetime-local" name="fecha_fin" class="form-control" value="{{ old('fecha_fin',$comunicado->fecha_fin) }}">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <label for="activo">Estado</label>
            <select name="activo" class="form-control">
                <option value="">-- SELECCIONE --</option>
                <option value="1" {{ old('estado',$comunicado->activo) == 1 ? 'selected' : '' }}>Activo</option>
                <option value="0" {{ old('estado',$comunicado->activo) == 0 ? 'selected' : '' }}>Inactivo</option>
            </select>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="archivo_tipo">Tipo de archivo <span class="text-danger">(*)</span></label>
            <select name="archivo_tipo" class="form-control">
                <option value="">-- SELECCIONE --</option>
                <option value="DOCUMENTO" {{ old('archivo_tipo',$comunicado->archivo_tipo) == 'DOCUMENTO' ? 'selected' : '' }}>DOCUMENTO</option>
                <option value="IMAGEN" {{ old('archivo_tipo',$comunicado->archivo_tipo) == 'IMAGEN' ? 'selected' : '' }}>IMAGEN</option>
            </select>
        </div>
    </div>
</div>
<div class="text-center mt-3">
    <button type="submit" class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('comunicados.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>