@extends('admin.layouts.app_admin')
@section('titulo','Directorio Empleados')
@section('content')


<div class="page-inner">
  <div class="page-header">
      <h4 class="page-title">Ver Directorio</h4>
      <ul class="breadcrumbs">
          <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="javascript:void(0)">Directorio</a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="#">Ver Directorio</a></li>
      </ul>
  </div>
  <div class="row">
      <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <div>
                      <div class="card-title">Directorio de empleados </div>
                      <div class="card-category">Listado de empleados registrados para cada unidad.</div>
                    </div>
                    @can('directorio_empleados.create')
                      <div>
                          <a href="{{ route('directorio_empleados.create') }}" class="btn btn-primary btn-rounded">Agregar Nuevo</a>
                          {{-- <a href="{{ route('directorio_empleados.import.create') }}" class="btn btn-primary btn-rounded">Agregar Desde Archivo</a> --}}
                      </div>
                    @endcan
                  </div>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table table-hover table-sm" id="datos">
                    <thead>
                      <th class="text-center">Interno</th>
                      <th class="text-center">Nombre Completo</th>
                      <th class="text-center">Cargo</th>
                      <th class="text-center">Unidad</th>
                      <th class="text-center">Area</th>
                      <th class="text-center"></th>
                    </thead>
                    <tbody>
                      @foreach($directorio_empleados as $directorio)
                        <tr>
                          <td class="text-center">{{ $directorio->interno }}</td>
                          <td class="text-left">{{ $directorio->nombre }}</td>
                          <td class="text-left">{{ $directorio->cargo }}</td>
                          <td class="text-center">{{ $directorio->unidad ? $directorio->unidad->nombre : '' }}</td>
                          <td class="text-center">{{ $directorio->unidad ? $directorio->unidad->area->nombre : '' }}</td>
                          <td class="text-center">
                            <button class="btn btn-default btn-round dropdown-toggle" type="button" data-toggle="dropdown"> 
                              OPCIONES
                              </button>
                              <ul class="dropdown-menu" role="menu">
                                  <li>
                                      @can('directorio_empleados.edit')
                                          <a class="dropdown-item" href="{{ route('directorio_empleados.edit', $directorio) }}">Modificar Datos</a>
                                      @endcan
                                      @can('directorio_empleados.destroy')
                                          <form action="{{ route('directorio_empleados.destroy', $directorio) }}" method="POST" style="display: inline-block;">
                                              @csrf
                                              @method('DELETE')
                                              <button type="submit" class="dropdown-item text-danger" onclick="return confirm('¿Está seguro que desea ELIMINAR el registro del DIRECTORIO?');">Eliminar</button>
                                          </form>
                                      @endcan
                                  </li>
                              </ul>
                          </td>
                        </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </div>
          </div>
      </div>
  </div>
</div>
@endsection
@section('scripts')
<script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endSection