@extends('admin.layouts.app_admin')
@section('titulo','Administración Documentos Generales')
@section('content')

<div class="page-inner">
  <div class="page-header">
    <h4 class="page-title">Administración de Documentos Generales</h4>
    <ul class="breadcrumbs">
        <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Administrar Documentos Generales</a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Ver Registrados</a></li>
    </ul>
  </div>
  <div class="row">
      <div class="col-lg-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title">Documentos generales registrados</h4>
                    
                    @can('documentos_generales.create')
                      <a href="{{ route('documentos_generales.create') }}" class="btn btn-primary btn-round">Agregar Nuevo</a>
                    @endif
                  </div>
              </div>
              <div class="card-body">
                @livewire('admin.admin-documento-general-component',['seccion'=>$seccion])
              </div>
          </div>
      </div>
  </div>

</div>
@endsection
