@extends('admin.layouts.app_admin')
@section('titulo','Administración Documentos Internos')
@section('content')

<div class="page-inner">
  <div class="page-header">
    <h4 class="page-title">Administración de Documentos Internos</h4>
    <ul class="breadcrumbs">
        <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Administrar Documentos Internos</a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Ver Registrados</a></li>
    </ul>
  </div>
  <div class="row">
      <div class="col-lg-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title">Documentos internos registrados</h4>
                    @can('documentos_internos.create')
                    <a href="{{ route('documentos_internos.create') }}" class="btn btn-primary btn-round" data-toggle="tooltip" title="Agregar un nuevo documento interno">Agregar Nuevo</a>
                    @endif
                  </div>
                </div>
                <div class="card-body pt-2">
                <p>Puede filtrar los registros de la tabla utilizando los campos de filtro que son de selección y un campo de busqueda donde ingresa el texto a buscar.</p>
                
                @livewire('admin.admin-documento-interno-component',['seccion'=>$seccion])
              </div>
          </div>
      </div>
  </div>

</div>
@endsection
