<p>Para agregar una opción al menú que se muestra en el intranet debe ingresar el nombre que se mostrará si es un menú sin submenus debe ingresar el icono, ingresar la url el orden en el que se mostrará. Si la nueva opción es un submenú, se ingresa el nombre la url, el orden y el item padre o menú padre.</p>
<p>Los campos marcados con <strong class="text-danger">(*)</strong> son obligatorios.</p>
@if ($errors->any())
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="row">
    <div class="col-md-6">
        <div class="form-group pt-0 {{ $errors->has('name') ? 'has-error' : '' }}">
            <label for="name">Nombre <span class="text-danger">(*)</span></label>
            <input type="text" class="form-control" id="name" name="name" value="{{  old('name',$menuItem->name) }}">
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group pt-0 {{ $errors->has('icono') ? 'has-error' : '' }}">
            <label for="name">Icono</label>
            <select name="icono" id="iconSelect" class="form-control">
                <option value="">--SELECCIONE--</option>
                @foreach ($iconos as $i)
                    <option value="{{ $i->nombre }}" {{ old('icono', $menuItem->icono) == $i->nombre ? 'selected' : '' }} data-icon="{{ $i->nombre }}">{{ $i->nombre }}</option>
                @endforeach
            </select>
            <small>(Solo para menú padre)</small>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="form-group pt-0 {{ $errors->has('url') ? 'has-error' : '' }}">
            <label for="url">URL (opcional para menú padre)</label>
            <input type="text" class="form-control" id="url" name="url" value="{{ old('url',$menuItem->url) }}">
            <label class="form-radio-label">
                <input class="form-radio-input" type="radio" name="tipo_url" value="1" {{ old('tipo_url',$menuItem->tipo_url != null ? $menuItem->tipo_url : '') == 1 ? 'checked' : '' }}>
                <span class="form-radio-sign">URL Externa</span>
            </label>
            <label class="form-radio-label ml-3">
                <input class="form-radio-input" type="radio" name="tipo_url" value="0" {{ old('tipo_url',$menuItem->tipo_url != null ? $menuItem->tipo_url : '') == 0 ? 'checked' : '' }}>
                <span class="form-radio-sign">URL Interna</span>
            </label>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group pt-0 {{ $errors->has('order') ? 'has-error' : '' }}">
            <label for="order">Orden o posición en el menú <span class="text-danger">(*)</span></label>
            <input type="number" class="form-control" id="order" name="order" value="{{ old('order', $menuItem->order) }}" >
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group pt-0">
            <label for="visible">La Opción será visible para:</label>
            <select name="visible" id="visible" class="form-control">
                <option value="3" {{ old('visible',$menuItem->visible != null ? $menuItem->visible : '') == 3 ? 'selected' : '' }}>Ambos Intranets</option>
                <option value="1" {{ old('visible',$menuItem->visible != null ? $menuItem->visible : '') == 1 ? 'selected' : '' }}>Solo Intranet Sedem</option>
                <option value="2" {{ old('visible',$menuItem->visible != null ? $menuItem->visible : '') == 2 ? 'selected' : '' }}>Solo Intranet Unidad</option>
            </select>
        </div>
    </div>
</div>
<div class="form-group pt-0">
    <label for="parent_id">Ítem padre (opcional)</label>
    <select class="form-control" id="parent_id" name="parent_id">
        <option value="">Ninguno (ítem de nivel superior)</option>
        @foreach($parentItems as $id => $name)
            <option value="{{ $id }}" {{ (isset($menuItem) && $menuItem->parent_id == $id) ? 'selected' : '' }}>
                {{ $name }}
            </option>
        @endforeach
    </select>
</div>
<h3 class="mt-3 fw-bold">Personalización del estilo y descripciones de las opciones principales del intranet.</h3>
<div class="row">
    <div class="col-md-4">
        <div class="form-group pt-0">
            <label for="titulo_pagina">Titulo de la página <span class="text-danger">(*)</span></label>
            <input type="text" class="form-control" id="titulo_pagina" name="titulo_pagina" value="{{  old('titulo_pagina',$menuItem->titulo_pagina) }}">
        </div>
    </div>
    <div class="col-md-8">
        <div class="form-group pt-0">
            <label for="descripcion_pagina">Descripción de la página <span class="text-danger">(*)</span></label>
            <input type="text" class="form-control" id="descripcion_pagina" name="descripcion_pagina" value="{{  old('descripcion_pagina',$menuItem->descripcion_pagina) }}">
        </div>
    </div>
    <div class="col-md-12">
        <div class="form-group pt-0">
            <label for="banner_pagina" >Imágen de fondo de la página <span class="text-danger">(*)</span></label>
            <input type="file" name="banner_pagina" id="banner_pagina"  class="form-control" accept="image/*" >
            <img id="vistaPrevia" src="{{ asset('assets/img/'.$menuItem->banner_pagina) }}" alt="Vista previa" style="{{ $menuItem->banner_pagina==null ? 'display:none' :''}}; max-width: 400px;">
        </div>
    </div>
</div>

<div class="text-center">
    <button type="submit" class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('menu.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>