@extends('admin.layouts.app_admin')
@section('titulo','Ver Noticia')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Previsualización de la Noticia / Anuncio</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Administrar Noticias</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Ver Noticia</a></li>
        </ul>
    </div>
    <div class="row mt--2">
        <div class="col-lg-12">
            <div class="card mb-3">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">{{ $noticia->titulo }}</h4>
                        <a href="{{ route('noticias.index') }}" class="btn btn-warning btn-rounded">Salir</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="text-center mb-5"><img src="{{ asset('adjuntos/'.$noticia->adjunto) }}" alt="Noticia" class="img-noticia" style="width: 50%; height: 50%; object-fit: cover;"></div>
                    {!! preg_replace('/(<br\s*\/?>\s*)/', '<br>', nl2br(e($noticia->descripcion))) !!}
                </div>
                <div class="text-center mb-3">
                    <a href="{{ route('noticias.index') }}" class="btn btn-warning btn-rounded">Salir</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
