@extends('admin.layouts.app_admin')
@section('titulo','Permisos de Rol')
@section('content')

<div class="page-inner">
  <div class="page-header">
      <h4 class="page-title">Configuración Accesso</h4>
      <ul class="breadcrumbs">
          <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="javascript:void(0)">Roles</a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="javascript:void(0)">Permisos asignados al Rol</a></li>
      </ul>
  </div>
  <div class="row">
      <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                  <div class="card-title">{{ $role->name }}</div>
                  <a href="{{route('roles.index')}}" class="btn btn-warning btn-round">Salir</a>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th width="20%">Grupo</th>
                                <th width="15%">Estado</th>
                                <th width="65%">Permisos</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($grupos as $grupo)
                                @php
                                    // Permisos que tiene el rol en este grupo
                                    $permisosRolGrupo = $permissions->where('grupo', $grupo->grupo);
                                    
                                    $permisosHabilitados = $permisosRolGrupo->count();
                                    $totalPermisos = $conteoPermisosPorGrupo[$grupo->grupo] ?? 0;
                                    $idsPermisosRol = $permissions->pluck('id')->toArray();
                                @endphp
                                
                                <tr>
                                    <td>
                                        <strong>{{ $grupo->grupo }}</strong>
                                       
                                        <small class="text-muted">
                                            ({{ $permisosHabilitados }}/{{ $totalPermisos }} permisos)
                                        </small>
                                    </td>
                                    <td>
                                        @if($permisosHabilitados > 0)
                                            <span class="badge badge-success">
                                                <i class="fas fa-check mr-1"></i>Activo
                                            </span>
                                            <div class="progress mt-1" style="height: 4px;">
                                                <div class="progress-bar bg-success" 
                                                    style="width: {{ ($permisosHabilitados / $totalPermisos) * 100 }}%">
                                                </div>
                                            </div>
                                        @else
                                            <span class="badge badge-secondary">
                                                <i class="fas fa-times mr-1"></i>Sin permisos
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @php
                                            // Obtener todos los permisos de este grupo desde el controlador
                                            $todosPermisosGrupo = collect();
                                            foreach($permissions as $p) {
                                                if($p->grupo == $grupo->grupo) {
                                                    $todosPermisosGrupo->push($p);
                                                }
                                            }
                                        @endphp
                                        
                                        @if($permisosRolGrupo->count() > 0)
                                            <div class="d-flex flex-wrap">
                                                @foreach($permisosRolGrupo as $permission)
                                                    <span class="badge  mr-1 mb-1" 
                                                        title="{{ $permission->name }}">
                                                        <i class="fas fa-check mr-1"></i>
                                                        {{ $permission->descripcion ?: $permission->name }}
                                                    </span>
                                                @endforeach
                                                
                                                @if($permisosHabilitados < $totalPermisos)
                                                    <span class="badge badge-light text-muted mr-1 mb-1">
                                                        <i class="fas fa-ellipsis-h"></i>
                                                        +{{ $totalPermisos - $permisosHabilitados }} sin asignar
                                                    </span>
                                                @endif
                                            </div>
                                        @else
                                            <span class="text-muted">
                                                <i class="fas fa-times mr-1"></i>
                                                Sin permisos asignados ({{ $totalPermisos }} disponibles)
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
              </div>
          </div>
      </div>
  </div>
</div>
@endsection