@extends('admin.layouts.app_admin')
@section('titulo','Administración de Sociales y Comunidad')
@section('content')

<div class="page-inner">
  <div class="page-header">
    <h4 class="page-title">Administración de Sociales y Comunidad</h4>
    <ul class="breadcrumbs">
        <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Administrar Sociales y Comunidad</a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Ver Registrados</a></li>
    </ul>
  </div>
  <div class="row">
      <div class="col-lg-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title">Sociales y Comunidad registrados</h4>
                    @can('sociales.create')
                      <a href="{{ route('sociales.create') }}" class="btn btn-primary btn-round">Agregar Nuevo</a>
                    @endif
                  </div>
              </div>
              <div class="card-body">
                @livewire('admin.social-comunidad-component',['seccion'=>$seccion])
              </div>
          </div>
      </div>
  </div>
</div>
@endsection

