@if ($errors->any())
    <h5 class="text-danger">CORRIJA ESTOS ERRORES:</h5>
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<p>Los campos marcados con <strong class="text-danger">(*)</strong> son obligatorios.</p>
<p>En campo <strong>ORDEN</strong> se utiliza para ordenar las unidades dependientes dentro del área al momento de mostrar el directorio de empleados</p>
<div class="row mb-1 {{ $errors->has('area_id') ? 'has-error' : '' }}">
    <label for="area_id" class="col-md-4 col-form-label text-right mt-2">Área de dependencia: </label>

    <div class="col-md-8 mb-0 pb-0">
        <select name="area_id"  class="form-control form-control {{ $errors->has('area_id') ? ' form-control-danger' : '' }}" id="area_id"  data-ruta="{{ route('admin.empleados.search') }}">
            <option value="">--BUSQUE Y SELECCIONE--</option>
            @foreach($areas as $area)
                <option value="{{$area->id}}" {{ old('area_id', $unidad->area_id == null ? $area->id : $unidad->area_id )== $area->id ? 'selected' : '' }}>{{ $area->codigo }} - {{ $area->nombre }}</option>
            @endforeach
        </select>
    </div>
</div>

<div class="row mb-1 {{ $errors->has('nombre') ? 'has-error' : '' }}">
    <label for="nombre" class="col-md-4 col-form-label text-right ">Nombre Unidad <span class="text-danger">(*)</span></label>
    <div class="col-md-8">
        <input id="nombre" type="text" class="form-control{{ $errors->has('nombre') ? ' form-control-danger' : '' }}" name="nombre" value="{{ old('nombre',$unidad->nombre) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
    </div>
</div>
<div class="row mb-1 {{ $errors->has('orden') ? 'has-error' : '' }}">
    <label for="orden" class="col-md-4 col-form-label text-right ">Orden <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="ordenUnidad" type="number" class="form-control{{ $errors->has('orden') ? ' form-control-danger' : '' }}" name="orden_unidad" value="{{ old('orden',$area->orden) }}">
    </div>
</div>

<div class="text-center">
    <button class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('unidades.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>
