
@extends('admin.layouts.app_admin')
@section('titulo','Usuarios')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Usuarios</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Configuración Accesso</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Usuarios</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Usuarios registrados hasta la fecha</h4>
                        @can('users.create')<a href="{{ route('users.create') }}" class="btn btn-primary btn-round mr-2">Agregar Nuevo</a>@endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="table-responsive">
                                <table width="100%" id="datos" class="table table-hover table-sm">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Nombre Completo</th>
                                            <th class="text-center">CI</th>
                                            <th class="text-center">Nombre de Usuario</th>
                                            <th class="text-center">Correo Institucional</th>
                                            <th class="text-center">Rol Asignado</th>
                                            <th class="text-center">Unidad SEDEM</th>
                                            <th class="text-center">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($users as $user)
                                        @if($user->id != 1 && $user->id != auth()->user()->id)
                                            <tr>
                                                <td>{{$user->name}}</td>
                                                <td class="text-center">{{$user->empleado_ci}}</td>
                                                <td class="text-center">{{$user->username}}</td>
                                                <td class="text-center">{{$user->email}}</td>
                                                <td class="text-center">
                                                    @foreach ($user->roles as $rol )
                                                        <strong>{{$rol->name}}</strong>
                                                    @endforeach
                                                </td>
                                                <td class="text-center">{{ $user->unidad ? $user->unidad->nombre : '--UNIDAD ELIMINADA--' }}</td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center">
                                                        @can('users.edit')
                                                            <a href="{{route('users.edit',$user->id)}}" class="btn btn-warning btn-round btn-icon " title="Modificar datos"><button class="btn btn-warning btn-round btn-icon "><i class="fas fa-edit"></i></button></a>
                                                        @endcan
                                                        @can('users.destroy')
                                                            <a href="{{route('users.destroy',$user->id)}}"  title="Eliminar Registro" onclick="return confirm('¿Está seguro que desea eliminar al USUARIO?');"><button class="btn btn-danger btn-round btn-icon "><i class="fas fa-trash-alt"></i></button></a>
                                                        @endcan
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
 <script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endsection