<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>{{ config('app.name') }}</title>
  <link rel="shortcut icon" href="{{ asset('favicon.ico') }}">

  <link href="https://fonts.googleapis.com/css?family=Karla:400,700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.materialdesignicons.com/4.8.95/css/materialdesignicons.min.css">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
  <link rel="stylesheet" href="{{ asset('assets_login/css/login.css') }}">
  <!-- Sweet Alert --> 
  <script src="{{ asset('assets/js/plugin/sweetalert/sweetalert.min.js') }}"></script>
  <style>
    .captcha-container {
        max-width: 100%;
        display: flex;
        justify-content: center;
    }
    
    .captcha-img {
        width: 100%;
        max-width: 250px; /* ancho máximo en desktop */
        height: auto;
    }
  </style>
</head>
<body>
  <main class="d-flex align-items-center min-vh-100 py-3 py-md-0">
    <div class="container">
      <div class="card login-card">
        <div class="row no-gutters">
          <div class="col-md-5">
            <img src="{{ asset('assets_login/images/login1.png') }}" alt="login" class="login-card-img">
          </div>
          <div class="col-md-7">
            <div class="card-body">
              <div class="brand-wrapper text-center">
                <img src="{{ asset('assets_login/images/logo_intranet.png') }}" alt="logo" class="logo d-sm-none d-md-block d-lg-block" >
                <img src="{{ asset('assets_login/images/Logo_intranet_small.png') }}" alt="logo" class="logo d-md-none d-lg-none" >
              </div>
              <br>
              @include('sweetalert::alert')
            
              <p class="login-card-description">Bienvenid@ !!! <br>Ingrese sus datos para acceder, nombre de usario y contraseña</p>
              <p class="alert alert-warning">
                Por ejem. Si su correo es juan.perez@sedem.gob.bo solo considerar <strong>juan.perez </strong>, contraseña de su equipo o correo.
              </p>
              <form action="{{ route('login') }}" method="POST">
                @csrf
                @if ($errors->any())
                    <ul style="list-style: none; " class="alert-danger">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif
                  <div class="form-group mb-0 {{ $errors->has('username') ? 'has-error' : '' }}">
                    <label for="username" class="sr-only">Nombre de Usuario</label>
                    <input type="text" class="form-control mb-3" placeholder="Nombre de usuario" name="username" value="{{ old('username') }}"  autocomplete="username" autofocus>
                    
                  </div>
                  <div class="form-group mb-0 {{ $errors->has('password') ? 'has-error' : '' }}">
                    <label for="password" class="sr-only">Contraseña</label>
                    <input type="password" class="form-control mb-1" placeholder="Contraseña" name="password"  autocomplete="current-password">
                    
                  </div>
                  <div class="d-flex justify-content-center">
                      <div class="captcha-container mb-0">
                          <img src="{{ captcha_src('large') }}" alt="captcha" class="captcha-img" id="captcha-image">
                          <button type="button" class="btn btn-danger btn-refresh-captcha" id="refresh-captcha" title="">
                              ↻
                          </button>
                      </div>
                  </div>
                 <div class="input-group ">
                          <input id="captcha" type="text" class="form-control @error('captcha') is-invalid @enderror"  placeholder="Ingrese el texto captcha"
                              name="captcha"  autocomplete="off">
                  </div>
                  <button type="submit" class="btn btn-block login-btn mb-4">Ingresar</button>
                </form>
                <!-- <div class="text-right"><a href="{{ route('redirect') }}" class="btn btn-seconday btn-icon" target="_blank"><i class="fas fa-edit"></i>X</a></div> -->
            </div>
          </div>
        </div>
      </div>

    </div>
  </main>
  <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"></script>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('refresh-captcha').addEventListener('click', function() {
        // Añadimos un parámetro aleatorio para evitar el caché
        document.getElementById('captcha-image').src = '{{ captcha_src('large') }}?' + Math.random();
    });
});
    </script>
</body>
</html>
