
@extends('intranet.layouts.app')
@section('titulo','Capacitación')
@section('content')

<div class="panel-header img-fondo" style="background-image: url({{ asset('assets/img/'.$pagina->banner_pagina) }});">
    <div class="page-inner py-{{ session('unidad_id')==null ? '5' : '4' }}">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row" style="z-index: 2;">
            <div>
                @if(session('unidad_id')!=null) <h1 class="text-white mb-0 pb-0 fw-bold" style="position: relative; z-index: 3;"> {{ session('nombre_unidad') }} </h1>@endif
                <h1 class="text-white pb-0 mb-0 fw-bold" style="position: relative; z-index: 3;">{{ $pagina->titulo_pagina }}</h1>
                <h3 class="text-white mb-2" style="position: relative; z-index: 3;">{{ $pagina->descripcion_pagina }}</h3>
            </div>
        </div>
    </div>
</div>
{{-- <div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Videos de capacitación disponibles</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        @forelse ($archivos as $video)
                            <div class="col-md-4">
                                <div class="card card-post card-round">
                                    <div class="card-body video-container">
                                        {{-- <img src="{{ asset('adjuntos/'.$video->adjunto) }}" alt=""> --}}
                                        {{-- <a href="javascript:void(0)" data-toggle="modal" data-target="#videoModal" data-video-url="{{ route('ver_adjuntos',$video->id) }}">
                                            <video  preload="metadata" controls >
                                                <source src="{{ route('ver_adjuntos',$video->id) }}" type="video/mp4" >
                                            </video>
                                        </a>
                                        <p class="card-category text-info mb-1">{{ $video->tipo }}</p>
                                        <span class="badge badge-gray">{{ $video->unidad_id != null ? $video->unidad->nombre : 'SEDEM' }}</span><br>
                                        <span class="text-primary fw-bold">Publicado por: {{ $video->creador->name }}</span>
                                        <h3 class="mt-1">
                                            {{ date('d/m/Y',strtotime($video->fecha)) }} | {{ $video->titulo }} - {{ $video->descripcion }}
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="col-md-12  bg-warning-light text-center">
                                <h3 class="pt-2 pb-2 ">No se publicaron videos de capacitación...</h3>
                            </div>
                        @endforelse
                    </div>   
                </div>
            </div>
        </div>
    </div>
</div> --}}
<div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h4 class="card-title">Videos de capacitación para el personal <strong>{{ $search != null ? 'buscando por "'.$search.'"' : '' }}</strong></h4>
                        </div>
                        <div class="col-md-6 ">
                            <div class="d-flex justify-content-end">
                                @if($search!=null)
                                    <a href="{{ route('capacitacion.show') }}" class="btn btn-link">
                                        <span class="btn-label">
                                            <i class="fa fa-link"></i>
                                        </span>Ver Todas
                                    </a>
                                @endif
                                <div class="collapse" id="search-nav">
                                    <form class="navbar-left navbar-form nav-search" action="{{ route('capacitacion.show') }}" method="get">
                                       <div class="input-group">
                                          <div class="input-group-prepend">
                                             <button type="submit" class="btn btn-search pr-1" data-toggle="tooltip" title="Presionar para realizar la búsqueda">
                                                <i class="fa fa-search search-icon"></i>
                                             </button>
                                          </div>
                                          <input type="text" placeholder="Ingrese una texto para la busqueda..." class="form-control " name="search" id="search">
                                       </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                   
                </div>
            </div>
        </div>
    </div>
</div> 
<div class="page-inner mt--5">
    <div class="row mt--2">
        @forelse ($archivos as $video)
        <div class="col-md-4 pb-3">
            <div class="card video-container card-round alto">
                <a href="javascript:void(0)"  style="height: 300px; width: 100%; background-size: cover; background-position: center">
                    <video  preload="metadata" controls >
                        <source src="{{ route('ver_adjuntos',$video->id) }}" type="video/mp4" >
                    </video>
                </a>
                <div class="card-body pb-0 mb-0 pt-2">       
                    <h3 class="mt-1">{{ date('d/m/Y',strtotime($video->fecha)) }} - {{ $video->titulo }} </h3>
                    <h3>{!! nl2br(preg_replace(
                        '/(https?:\/\/[^\s]+)/',
                        '<a href="$1" target="_blank" rel="noopener noreferrer">$1</a>',
                        e($video->descripcion)
                    )) !!}</h3>
                </div>
            </div>
        </div>
        @empty
        <div class="col-md-12  bg-warning-light text-center">
            <h3 class="pt-2 pb-2 ">No se encontraron archivos...</h3>
        </div>          
        @endforelse
    </div>
</div>
        <!-- Modal -->
<div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="videoModalLabel">Reproduciendo Video</h5>
                <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">X</button>
            </div>
            <div class="modal-body">
                <video id="videoPlayer" controls style="width: 100%;">
                    <source src="" type="video/mp4">
                    Tu navegador no soporta el elemento de video.
                </video>
            </div>
        </div>
    </div>
</div>
 @endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const playButtons = document.querySelectorAll('.play-video');
        const videoModal = new bootstrap.Modal(document.getElementById('videoModal'));
        const videoPlayer = document.getElementById('videoPlayer');

        playButtons.forEach(button => {
            button.addEventListener('click', function() {
                const videoUrl = this.getAttribute('data-video-url');
                videoPlayer.src = videoUrl;
                videoModal.show();
            });
        });

        videoModal._element.addEventListener('hidden.bs.modal', function () {
            videoPlayer.pause();
            videoPlayer.currentTime = 0;
        });
    });
</script>
@endsection
