@extends('intranet.layouts.app')
@section('titulo','Directorio')
@section('content')
<div class="panel-header img-fondo" style="background-image: url({{ asset('assets/img/'.$pagina->banner_pagina) }});">
    <div class="page-inner py-{{ session('unidad_id')==null ? '5' : '4' }}">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row" style="z-index: 2;">
            <div>
                @if(session('unidad_id')!=null) <h1 class="text-white mb-0 pb-0 fw-bold" style="position: relative; z-index: 3;"> {{ session('nombre_unidad') }} </h1>@endif
                <h1 class="text-white pb-0 mb-0 fw-bold" style="position: relative; z-index: 3;">{{ $pagina->titulo_pagina }}</h1>
                <h3 class="text-white mb-2" style="position: relative; z-index: 3;">{{ $pagina->descripcion_pagina }}</h3>
            </div>
        </div>
    </div>
</div>
<div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Listado de internos de la institución</h4>
                        <div>
                            <a class="btn btn-success btn-rounded" href="{{ route('directorio.xls') }}" onclick="event.preventDefault(); document.getElementById('exportar_excel').submit();">
                                Descargar Excel
                            </a>
                            <a class="btn btn-primary btn-rounded" href="{{ route('directorio.pdf') }}" onclick="event.preventDefault(); document.getElementById('exportar_pdf').submit();" target="_blank">
                                Descargar PDF
                            </a>
                            <form id="exportar_excel" action="{{ route('directorio.xls') }}" method="POST" style="display: none;">
                                @csrf
                                {{ Form::hidden('directorio', base64_encode(serialize($directorio))) }}
                            </form>
                            <form id="exportar_pdf" action="{{ route('directorio.pdf') }}" method="POST" style="display: none;" target="_blank">
                                @csrf
                                {{ Form::hidden('directorio', base64_encode(serialize($directorio))) }}
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datos" class="display table table-hover table-full-width" >
                            <thead>
                                <tr>
                                    <th class="text-center">Interno</th>
                                    <th class="text-center">Nombre</th>
                                    <th class="text-center">Unidad</th>
                                    <th class="text-center">Gerencia</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($directorio as $d)
                                    <tr>
                                        <td class="text-center"><strong><h2>{{$d->interno}}</h2></strong></td>
                                        <td class="text-left"> <div class="info-user ml-3">
                                            <h3 class="text-primary">{{ $d->nombre }}</h3>
                                            <div class="status">{{ $d->cargo }}</div>
                                        </div> </td>
                                        <td class="text-center">{{$d->unidad}}</td>
                                        <td class="text-center">{{$d->area}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        
                    </div>
                </div>
            </div>
        </div>
            
    </div>

</div>
@endsection

@section('scripts')
<script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endsection