@extends('intranet.layouts.app')
@section('titulo','Noticias')
@section('content')

<div class="panel-header img-fondo" style="background-image: url({{ asset('assets/img/'.$pagina->banner_pagina) }});">
    <div class="page-inner py-{{ session('unidad_id')==null ? '5' : '4' }}">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row" style="z-index: 2;">
            <div>
                @if(session('unidad_id')!=null) <h1 class="text-white mb-0 pb-0 fw-bold" style="position: relative; z-index: 3;"> {{ session('nombre_unidad') }} </h1>@endif
                <h1 class="text-white pb-0 mb-0 fw-bold" style="position: relative; z-index: 3;">{{ $pagina->titulo_pagina }}</h1>
                <h3 class="text-white mb-2" style="position: relative; z-index: 3;">{{ $pagina->descripcion_pagina }}</h3>
            </div>
        </div>
    </div>
</div>
<div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{ $noticia->titulo }}</h4>
                </div>
                <div class="card-body">
                    <div class="text-center mb-2"><img src="{{ asset('adjuntos/'.$noticia->adjunto) }}" alt="Noticia" class="img-noticia" style="width: 70%; height: 50%; object-fit: cover;"></div>
                    {!! preg_replace('/(<br\s*\/?>\s*)/', '<br>', nl2br(e($noticia->descripcion))) !!}
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="row">
                <div class="col-md-12">
                    <div class="card full-height">
                        <div class="card-header">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="card-title">Otras Noticias</div>
                                <a href="{{ route('noticias.publicadas') }}" class="btn btn-link">
                                    <span class="btn-label">
                                        <i class="fa fa-link"></i>
                                    </span>Ver Todas
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <ol class="activity-feed">
                                @foreach($noticias as $n)
                                    @if($n->id != $noticia->id)
                                        <li class="feed-item feed-item-secondary pb-1">
                                            <time class="date" datetime="9-25">{{ date('d/m/Y', strtotime($n->fecha)) }} </time>
                                            <span class="text">{{ $n->titulo }}<a href="{{ route('noticia.publicada', $n->id) }}" class="btn btn-link">Ver Noticia</a></span>
                                        </li>
                                    @endif
                                @endforeach
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
 @endsection
