<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Directorio de Empleados</title>
    <style>
        @page {
            margin: 0cm 0cm;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin-top: 2.5cm;
            margin-left: 1cm;
            margin-right: 1cm;
            margin-bottom: 1cm;
        }

        header {
            position: fixed;
            top: 0.5cm;
            left: 2cm;
            right: 2cm;
            height: 2cm;

        }
        footer .page:after {
            content: counter(page);
        }
        footer {
            position: fixed; 
            bottom: 1cm; 
            left: 1cm; 
            right: 1cm;
            height: 0.5cm;
        }
        footer .footer-table {
            width: 100%;
            border-top: solid 1px #5a5b5c;
            
        }
        .footer-table tr > td {
            border: none;
            padding: 0;
            margin: 0;
        }

        footer p {
            text-align: right;
            font-size: 10px;
        }

        footer .izq {
            text-align: left;
        }   
        
        .name {
            font-weight: bold;
            font-size: 12px;
        }
        .tabla-cabecera{
            width: 100%;
            border-bottom: solid 1px #909294;    
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        .tabla-cabecera tr > td{
            margin: 0;
            padding: 0px 0px 10px 0px;
            border: none ;
            vertical-align: middle;
        }
        .text-left{
            text-align: left;
        }
        .text-right{
            text-align: right;
        }
        .tabla-principal {
    width: 100%;
    border-collapse: collapse;
}

.columna {
    width: 50%;
    vertical-align: top;
    padding: 10px;
}

.tabla-empleados {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 20px;
}

.tabla-empleados th, .tabla-empleados td {
    border: 1px solid #000;
    padding: 5px;
    text-align: left;
}

h2 {
    text-align: center;
    margin-top: 30px;
    border-bottom: 2px solid #000;
    padding-bottom: 5px;
}

h4 {
    margin: 10px 0;
    text-decoration: underline;
}
    </style>
</head>
<body>
    <header >
        <table class="tabla-cabecera">
            <tr>
                <td class="text-left" style="width: 80%;"><h2>GUIA TELEFÓNICA DE INTERNOS DEL SEDEM Y SUS EPP's</h2></td>
                <td class="text-right" style="width: 20%;"><img src="{{ public_path().'/assets_login/images/logo_intranet.png' }}" class="logo images" style="width: 150px;"></td>
            </tr>
        </table>
    </header>
    <footer>
        <table class="footer-table">
            <tr>
                <td ><p class="izq">Generado el {{ date('d/m/Y H:i:s') }} </p></td>
                <td class="text-right"> <p class="page">Pagina </p></td>
            </tr>
        </table>
    </footer>
    @foreach ($areas as $area)
    <h2>{{ $area->nombre }}</h2>
    <table class="tabla-principal">
        <tr>
            @php $contador = 0; @endphp
            @foreach($area->unidades as $unidad)
                <td class="columna">
                    <h4>{{ $unidad->nombre }}</h4>
                    <table class="tabla-empleados">
                        <thead>
                            <tr>
                                <th>Interno</th>
                                <th>Nombre</th>
                                <th>Cargo</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($directorio->where('unidad_id', $unidad->id) as $empleado)
                                <tr>
                                    <td>{{ $empleado->interno }}</td>
                                    <td>{{ $empleado->nombre }}</td>
                                    <td>{{ $empleado->cargo }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </td>
                @php $contador++; @endphp
                @if ($contador % 2 == 0)
                    </tr><tr> {{-- Nueva fila después de dos columnas --}}
                @endif
            @endforeach
        </tr>
    </table>
@endforeach

    

</body>
</html>
