<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Directorio Telefónico Empresarial</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10pt;
            line-height: 1.3;
            margin: 0;
            padding: 15px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 1px solid #333;
            padding-bottom: 10px;
        }
        .logo {
            max-height: 100px;
            margin-bottom: 10px;
        }
        h1 {
            font-size: 18pt;
            margin: 0;
            color: #12283e;
        }
        h2 {
            font-size: 14pt;
            background-color: #12283e;
            color: white;
            padding: 5px 10px;
            margin-top: 20px;
            margin-bottom: 10px;
            page-break-after: avoid;
        }
        h4 {
            background-color: #045a72;
            color: white;
            padding: 5px;
            margin: 5px 0;
            font-size: 11pt;
        }
        .tabla-principal {
            width: 100%;
            border-collapse: separate;
            border-spacing: 10px;
            margin-bottom: 20px;
        }
        .columna {
            width: 48%;
            vertical-align: top;
            padding: 0;
        }
        .tabla-empleados {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        .tabla-empleados th {
            background-color: #75cccc;
            text-align: left;
            padding: 5px;
            font-weight: bold;
            border-bottom: 1px solid #ddd;
            font-size: 9pt;
        }
        .tabla-empleados td {
            padding: 5px;
            border-bottom: 1px solid #eee;
            font-size: 9pt;
        }
        td .interno {
            width: 15%;
            font-weight: bold;
            font-size: 14pt;
        }
        .nombre {
            width: 40%;
        }
        .cargo {
            width: 45%;
            font-style: italic;
        }
        .page-break {
            page-break-after: always;
        }
        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 8pt;
            color: #777;
            border-top: 1px solid #ddd;
            padding-top: 5px;
        }
        .page:after {
            content: counter(page);
        }
        .indice {
            columns: 2;
            margin-bottom: 20px;
        }
        .indice-item {
            margin-bottom: 5px;
        }
        .volver-inicio {
            position: fixed;
            top: 10px;
            right: 10px;
            background-color: #045a72;
            color: white;
            padding: 5px 10px;
            border-radius: 5px;
            text-decoration: none;
        }
        /* Colores para diferentes áreas */
        .area-1 { background-color: white; }
        .area-2 { background-color: white; }
        .area-3 { background-color: white; }
        .area-4 { background-color: white; }
        .area-5 { background-color: white; }
        .area-6 { background-color: white; }
        .text-right{
            text-align: right;
        }
    </style>
</head>
<body>
    <div class="header" id="indice">
        <img src="{{ public_path().'/assets/img/logo_sedem.png'  }}" class="logo" alt="Logo institucional" >
        <h1>GUIA TELEFONICA DE INTERNOS DEL SEDEM Y SUS EPPs </h1>
        
        <table style="width: 100%; text-align:right;">
            <tr><td><p>Actualizado al: {{ date('d/m/Y') }}</p></tr>
            <tr><td><strong>LINEA GRATUITA:</strong> 800102434</td></tr>
            <tr><td><strong>TELEFONOS:</strong> 2147001- 2145697 - 2147665</td></tr>
            <tr><td><strong>CORREO INSTITUCIONAL:</strong> sedem.nacional@sedem.gob.bo</td></tr>
        </table>
    </div>
    {{-- <div id="indice"></div> --}}
    <!-- Índice de Áreas -->
    <h2>INDICE</h2>
    <div>
        @foreach($areas as $area)
            <div class="indice-item">
                <a href="#area-{{ $area->id }}">{{ $area->nombre }}</a>
            </div>
        @endforeach
    </div>
    <!-- Contenido por Área -->
    @foreach($areas as $index => $area)
        <h2 id="area-{{ $area->id }}">{{ $area->nombre }}</h2>
        <table class="tabla-principal">
            <tr>
                @php $contador = 0; @endphp
                @foreach($area->unidades as $unidad)
                    <td class="columna">
                        <div class="area-{{ ($index % 6) + 1 }}">
                            <h4>{{ $unidad->nombre }}</h4>
                            <table class="tabla-empleados">
                                <thead>
                                    <tr>
                                        <th>Interno</th>
                                        <th class="nombre">Nombre</th>
                                        <th class="cargo">Cargo</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($directorio->where('unidad_id', $unidad->id) as $empleado)
                                        <tr>
                                            <td class="interno">{{ $empleado->interno }}</td>
                                            <td class="nombre">{{ $empleado->nombre }}</td>
                                            <td class="cargo">{{ $empleado->cargo }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </td>
                    @php $contador++; @endphp
                    @if($contador % 2 == 0 && $contador < count($area->unidades))
                        </tr><tr>
                    @endif
                @endforeach
                
                @if($contador % 2 != 0)
                    <td></td> <!-- Celda vacía para mantener el balance si hay un número impar -->
                @endif
            </tr>
        </table>
        
        @if(!$loop->last)
            <div class="page-break"></div>
        @endif
    @endforeach
    
    <div class="footer">
        <a href="#indice" class="volver-inicio">Volver al Inicio</a>
        Guía telefónica de internos del SEDEM y EPPs - Página <span class="page"></span>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const enlaceInicio = document.querySelector('.volver-inicio');
    
            enlaceInicio.addEventListener('click', (e) => {
                e.preventDefault();
                const inicio = document.getElementById('indice');
                window.scrollTo({
                    top: inicio.offsetTop,
                    behavior: 'smooth'
                });
            });
        });
    </script>
</body>
</html>