<div>
    <div class="row mb-3">
        <div class="col-md-2 mb-1 pl-0 pr-0">
            <div class="form-group pb-0 ">
                <i class="fas fa-filter mr-2"></i><label for="">Estado</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="estadoFiltro" class="form-control ">
                        <option value="">-- VER TODOS --</option>
                        <option value="true">Publicado</option>
                        <option value="false">No Publicado</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-md-2 mb-1 pl-0 pr-0">
            <div class="form-group pb-0 ">
                <i class="fas fa-filter mr-2"></i><label for="">Visible</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="visibleFiltro" class="form-control ">
                        <option value="">-- VER TODOS --</option>
                        <option value="1">Para Todos</option>
                        <option value="false">Solo Para la Unidad</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-1 pl-0 pr-0">
            <div class="form-group pb-0 pr-0">
                <i class="fas fa-filter mr-2"></i><label for="">Unidad Institucional</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="unidadFiltro" class="form-control unidad_id">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($unidades as $unidad)
                            <option value="{{ $unidad->id }}">{{ $unidad->nombre }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-primary btn-icon " wire:click="borrar_unidad" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        <div class="col-md-4 pl-0">
            <div class="form-group pb-0 pr-0">
                <i class="fas fa-search mr-2"></i><label for="">Buscar</label>
                <div class="d-flex align-items-center justify-content-center">
                    <input type="text" wire:model="search" id="searchFilter" class="form-control" placeholder="Ingrese una palabra....">
                    <button class="btn btn-primary btn-icon " wire:click="borrar_search" title="Borrar Contenido"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover table-sm datatable">
          <thead>
            <th class="text-center">Fecha</th>
              <th class="text-center">Título</th>
              <th class="text-center">Visible</th>
              <th class="text-center">Estado</th>
              <th class="text-center">Acciones</th>
          </thead>
          <tbody>
            @forelse($capacitaciones as $c)
              <tr>
                <td class="text-center">{{date('d/m/Y',strtotime( $c->fecha)) }}</td>
                  <td class="text-left"><a href="{{ route('ver_adjuntos',$c->id) }}" title="Ver adjunto" data-toggle="tooltip" target="_blank"> <i class="fas fa-download mr-2"></i><strong>TITULO:</strong>{{ $c->titulo }} </a>{{ $c->titulo }} <br>
                    <span class="badge badge-gray">{{ $c->unidad != null ? $c->unidad->nombre : 'SEDEM' }}</span><br>
                  </td>
                  <td class="text-center">@if($c->visible == 1) <span class="badge badge-success">PARA TODOS</span> @else <span class="badge badge-secondary">SOLO UNIDAD</span> @endif</td>
                  <td class="text-center">@if($c->estado==0) <span class="badge badge-danger">NO PUBLICADO</span> @else <span class="badge badge-success">PUBLICADO</span> @endif</td>
                <td class="text-center">
                  <button class="btn btn-default btn-round dropdown-toggle" type="button" data-toggle="dropdown"> 
                    OPCIONES
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <li>
                            @can('capacitaciones.edit')
                                <a class="dropdown-item" href="{{ route('capacitaciones.edit', $c) }}" href="#">Modificar Datos</a>
                                @if($c->estado==0)
                                    <a class="dropdown-item" href="{{ route('capacitaciones.publicar', [$c,1]) }}" onclick="return confirm('¿Está seguro que desea PUBLICAR el VIDEO DE CAPACITACIÓN?');">Publicar</a>
                                @else
                                    <a class="dropdown-item" href="{{ route('capacitaciones.publicar', [$c,0]) }}" onclick="return confirm('¿Está seguro que desea DAR DE BAJA la publicación del VIDEO DE CAPACITACIÓN?');">Dar de Baja</a>
                                @endif
                            @endcan
                            @can('capacitaciones.destroy')
                                <form action="{{ route('capacitaciones.destroy', $c) }}" method="POST" style="display: inline-block;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="dropdown-item text-danger" onclick="return confirm('¿Está seguro que desea ELIMINAR el VIDEO DE CAPACITACIÓN?');">Eliminar</button>
                                </form>
                            @endcan
                        </li>
                    </ul>
                </td>
              </tr>
              @empty
              <div class="bg-warning-light text-center">
                  <h3 class="pt-2 pb-2">No se encontraron resultados de acuerdo al filtro ingresado...</h3>
              </div>
            @endforelse
          </tbody>
        </table>
        <div class="d-flex justify-content-end">{{ $capacitaciones->links('pagination::bootstrap-4') }}</div>
      </div>
</div>
@section('scripts')
<script>
    $(document).ready(function () {
        window.initSelectFiltros=()=>{
            $('.unidad_id').select2();
        }
        initSelectFiltros();
       
        $('.unidad_id').on('change', function () {
                @this.set('unidadFiltro', $(this).val());
            });
        
            window.livewire.on('select2',()=>{
                initSelectFiltros();
            });
    });
</script>
@endsection
