<div>
    <div class="row mb-1">
        <div class="col-md-2 mb-1 pr-0">
            <div class="form-group pt-0">
                <i class="fas fa-filter mr-2"></i><label for="">Tipo Documento</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="tipoFiltroGral" class="form-control tipo_contenido" id="tipo">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($tipos as $t)
                            <option value="{{ $t->id }}">{{ $t->nombre }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_tipo" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-1 pl-0 pr-0">
            <div class="form-group pl-0 pt-0 ">
                <i class="fas fa-filter mr-2"></i><label for="">Grupo</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="grupoFiltroGral" class="form-control grupo" id="grupo">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($grupos as $g)
                            <option value="{{ $g->id }}">{{ $g->nombre }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_grupo" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-1 pl-0 pr-0">
            <div class="form-group pl-0 pt-0">
                <i class="fas fa-filter mr-2"></i><label for="">Unidad Institucional</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="unidadFiltroGral" class="form-control unidad_id" id="unidad">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($unidades as $unidad)
                            <option value="{{ $unidad->id }}">{{ $unidad->nombre }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_unidad" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-1 pl-0">
            <div class="form-group pl-0 pt-0">
                <i class="fas fa-search mr-2"></i><label for="">Buscar</label>
                <div class="d-flex align-items-center justify-content-center">
                    <input type="text" wire:model="searchGral" id="searchFilter" class="form-control" placeholder="Ingrese una palabra para la búsqueda....">
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_search" title="Borrar Contenido"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <div class="text-center">
                    <div wire:loading>
                        Filtrando.....
                    </div>
                </div>
                <table class="table table-hover" width="100%" cellspacing="0" style="width: 100%;">
                    <thead>
                        <tr>
                            <th class="text-center"></th>
                            <th class="text-center">Fecha</th>
                            <th class="text-center">Título</th>
                            <th class="text-center">Descripción</th>
                            <th class="text-center">Grupo</th>
                            <th class="text-center">Tipo Documento</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($documentos as $doc)
                        <tr>
                            <td class="text-center "><a class="btn btn-link btn-danger pb-0 pt-0" href="{{ route('ver_adjuntos', $doc) }} " target="_blank" title="Ver documento"><i class="fas fa-file-pdf"></i> Ver</a></td>
                            <td class="text-center">{{ date('d/m/Y',strtotime($doc->fecha)) }}</td>
                            <td class="text-left ">{{ $doc->titulo }} <br> <span class="badge badge-gray">{{ $doc->unidad != null ? $doc->unidad->nombre : 'SEDEM' }}</span> <h5 class="text-dark fw-bold">Publicado por: {{ $doc->creador->name }}</h5></td>
                            <td class="text-left ">{{ $doc->descripcion }} </td>
                            <td class="text-center"><span class="badge badge-success">{{ $doc->grupo != null ? $doc->grupo->nombre : '' }}</span></td>
                            <td class="text-center"><span class="badge badge-default">{{ $doc->tipo->nombre }}</span></td>
                        </tr>
                        @empty
                            <div class="bg-warning-light text-center">
                                <h3 class="pt-2 pb-2">No se encontraron resultados de acuerdo al filtro ingresado...</h3>
                            </div>
                        @endforelse
                    </tbody>
                </table>
                <div class="d-flex justify-content-end">{{ $documentos->links() }}</div>
            </div>
        </div>
    </div>
</div>
@section('scripts')
<script>
    $(document).ready(function () {
        window.initSelectCompanyDrop=()=>{
            $('.unidad_id').select2();
            $('.grupo').select2();
            $('.tipo_contenido').select2();
        }
        initSelectCompanyDrop();
        $('.tipo_contenido').on('change', function () {
                @this.set('tipoFiltroGral', $(this).val());
            });
        $('.grupo').on('change', function () {
                @this.set('grupoFiltroGral', $(this).val());
            });
        $('.unidad_id').on('change', function () {
                @this.set('unidadFiltroGral', $(this).val());
            });
        
            window.livewire.on('select2',()=>{
                initSelectCompanyDrop();
            });
    });
</script>
@endsection