<div class="modal fade" id="comunicadoModal" tabindex="-1" role="dialog" aria-labelledby="eventModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <button type="button" class="btn-close btn-close-white close-comunicado" data-bs-dismiss="modal" aria-label="Close"><i class="fa fa-times"></i></button>
            <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
                <?php if(count($comunicados) > 1): ?>
                    <div class="carousel-indicators">
                        <?php $__currentLoopData = $comunicados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $comunicado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button type="button" 
                                data-bs-target="#carouselExampleIndicators" 
                                data-bs-slide-to="<?php echo e($index); ?>" 
                                class="<?php echo e($index == 0 ? 'active' : ''); ?>" 
                                aria-current="<?php echo e($index == 0 ? 'true' : 'false'); ?>" 
                                aria-label="Comunicado <?php echo e($index + 1); ?>"></button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div> 
                <?php endif; ?>
                <div class="carousel-inner">
                    <?php $__currentLoopData = $comunicados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $comunicado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="carousel-item <?php echo e($index == 0 ? 'active' : ''); ?>">
                            <?php if($comunicado->archivo_tipo == 'IMAGEN'): ?>
                                <div class="d-flex justify-content-center align-items-center bg-dark" style="min-height: 80vh;">
                                    <img src="<?php echo e(asset('adjuntos/'.$comunicado->url)); ?>" 
                                        class="d-block img-fluid" 
                                        alt="<?php echo e($comunicado->titulo); ?>"
                                        style="max-height: 85vh; max-width: 100%; object-fit: contain;">
                                </div>
                            <?php else: ?>
                                    <div class="card mb-0">
                                        <div class="card-header border-0 flex-column pb-0">
                                            <div class="card-title">COMUNICADO</div>
                                            <div class="text-center mb-3">
                                                <img src="<?php echo e(asset('assets_login/images/logo_intranet.png')); ?>" alt="Logo" style="width:200px;">
                                            </div>
                                            <h2 class="card-title text-center w-100"><?php echo e($comunicado->titulo); ?></h2>
                                        </div>
                                        <div class="card-body ml-5 mr-5" style="max-height: 60vh; overflow-y: auto;">
                                            <?php if($comunicado->contenido): ?>
                                                <div class="mb-2" style="text-align: justify;">
                                                    <?php echo $comunicado->contenido; ?>

                                                </div>
                                            <?php endif; ?>
                                            <?php if($comunicado->url): ?>
                                                <a href="<?php echo e($comunicado->url); ?>" target="_blank" class="alert-link ">
                                                    Ver adjunto
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                        <div class="card-footer border-0 pt-2 pb-3 text-right">
                                            <button type="button" class="btn btn-primary btn-round px-4" data-bs-dismiss="modal">Cerrar</button>
                                        </div>
                                    </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php if(count($comunicados) > 1): ?>
                <button class="carousel-control-prev" id="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
                    ⟨
                </button>
                <button class="carousel-control-next" id="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
                    ⟩
                </button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<style>
    #carousel-control-prev,
    #carousel-control-next {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        background: transparent;
        border: none;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        font-size: 24px;
        font-weight: bold;
        color: #333;
        cursor: pointer;
        transition: all 0.3s ease;
        z-index: 1000;
        box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    }

    #carouselExampleIndicators .carousel-control-prev {
        left: 5px;
    }

    #carouselExampleIndicators .carousel-control-next {
        right: 5px;
    }

    #carousel-control-prev:hover,
    #carousel-control-next:hover {
        background: white;
        transform: translateY(-50%) scale(1.1);
        box-shadow: 0 6px 20px rgba(0,0,0,0.3);
    }

    /* En pantallas pequeñas, mostrar los botones dentro del modal */
    @media (max-width: 768px) {
        #carouselExampleIndicators .carousel-control-prev {
            left: 10px;
        }

        #carouselExampleIndicators .carousel-control-next {
            right: 10px;
        }
    }

    #carouselExampleIndicators .carousel-indicators {
        margin-bottom: 1.5rem;
    }

    #carouselExampleIndicators .carousel-indicators [data-bs-target] {
        width: 12px;
        height: 12px;
        border-radius: 50%;
        margin: 0 5px;
    }

    #carouselExampleIndicators .btn-close {
        opacity: 1;
    }

    #comunicadoModal .close-comunicado {
        position: absolute;
        top: 15px;
        right: 20px;
        z-index: 2000;
        background: rgba(255,255,255,0.8);
        padding: 10px 15px;
        border: none;
        /* box-shadow: 0 2px 6px rgba(0,0,0,0.3); */
    }
</style><?php /**PATH /var/www/html/intranet/resources/views/intranet/_modal_comunicados.blade.php ENDPATH**/ ?>