
<?php $__env->startSection('titulo','Registro de comunicados'); ?>
<?php $__env->startSection('content'); ?>


<div class="page-inner">
  <div class="page-header">
      <h4 class="page-title">Comunicados</h4>
      <ul class="breadcrumbs">
          <li class="nav-home"><a href="<?php echo e(route('home')); ?>"><i class="flaticon-home"></i></a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="javascript:void(0)">Comunicados</a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="#">Ver Registrados</a></li>
      </ul>
  </div>
  <div class="row">
      <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <div>
                      <div class="card-title">Listado de comunicados Registrados</div>
                    </div>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('comunicados.create')): ?>
                      <a href="<?php echo e(route('comunicados.create')); ?>" class="btn btn-primary btn-rounded">Agregar Nuevo</a>
                    <?php endif; ?>
                  </div>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="datos">
                        <thead>
                            <tr>
                              <th class="text-center">Estado</th>
                                <th class="text-center">Fecha Desde</th>
                                <th class="text-center">Fecha Hasta</th>
                                <th class="text-center">Título</th>
                                <th class="text-center">Contenido</th>
                                <th class="text-center">URL</th>
                                <th class="text-center">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $comunicados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comunicado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                  <td class="text-center"><?php if($comunicado->activo == true): ?> <span class="badge badge-success">ACTIVO</span> <?php else: ?> <span class="badge badge-default">INACTIVO</span> <?php endif; ?></td>
                                    <td class="text-center"><?php echo e(date('d/m/Y H:i', strtotime($comunicado->fecha_inicio))); ?> </td>
                                    <td class="text-center"><?php echo e(date('d/m/Y H:i', strtotime($comunicado->fecha_fin))); ?></td>
                                    <td class="text-center"><?php echo e($comunicado->titulo); ?></td>
                                    <td class="text-center"><?php echo e($comunicado->contenido); ?> </td>
                                    <td class="text-center"><?php if($comunicado->url != null): ?> <a href="<?php echo e(route('ver_adjuntos',$comunicado->id)); ?>" title="Ver adjunto" data-toggle="tooltip" target="_blank"> <i class="fas fa-download mr-2"></i> Ver </a> <?php endif; ?></td>
                                    <td class="d-flex justify-content-center align-items-center">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('comunicados.edit')): ?>
                                          <a href="<?php echo e(route('comunicados.edit', $comunicado)); ?>" class="btn btn-warning btn-icon btn-round"><i class="fas fa-edit pt-1 mt-2"></i></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('comunicados.destroy')): ?>
                                          <form action="<?php echo e(route('comunicados.destroy', $comunicado)); ?>" method="POST" style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button class="btn btn-danger btn-icon btn-round" onclick="return confirm('¿Esta seguro que desea ELIMINAR el COMUNICADO?');"><i class="fas fa-trash-alt"></i></button>
                                          </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
              </div>
          </div>
      </div>
  </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/js/tablas/basica.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/intranet/resources/views/admin/comunicados/index.blade.php ENDPATH**/ ?>