
<?php $__env->startSection('titulo','Directorio'); ?>
<?php $__env->startSection('content'); ?>
<div class="panel-header img-fondo" style="background-image: url(<?php echo e(asset('assets/img/'.$pagina->banner_pagina)); ?>);">
    <div class="page-inner py-<?php echo e(session('unidad_id')==null ? '5' : '4'); ?>">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row" style="z-index: 2;">
            <div>
                <?php if(session('unidad_id')!=null): ?> <h1 class="text-white mb-0 pb-0 fw-bold" style="position: relative; z-index: 3;"> <?php echo e(session('nombre_unidad')); ?> </h1><?php endif; ?>
                <h1 class="text-white pb-0 mb-0 fw-bold" style="position: relative; z-index: 3;"><?php echo e($pagina->titulo_pagina); ?></h1>
                <h3 class="text-white mb-2" style="position: relative; z-index: 3;"><?php echo e($pagina->descripcion_pagina); ?></h3>
            </div>
        </div>
    </div>
</div>
<div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Listado de internos de la institución</h4>
                        <div>
                            <a class="btn btn-success btn-rounded" href="<?php echo e(route('directorio.xls')); ?>" onclick="event.preventDefault(); document.getElementById('exportar_excel').submit();">
                                Descargar Excel
                            </a>
                            <a class="btn btn-primary btn-rounded" href="<?php echo e(route('directorio.pdf')); ?>" onclick="event.preventDefault(); document.getElementById('exportar_pdf').submit();" target="_blank">
                                Descargar PDF
                            </a>
                            <form id="exportar_excel" action="<?php echo e(route('directorio.xls')); ?>" method="POST" style="display: none;">
                                <?php echo csrf_field(); ?>
                                <?php echo e(Form::hidden('directorio', base64_encode(serialize($directorio)))); ?>

                            </form>
                            <form id="exportar_pdf" action="<?php echo e(route('directorio.pdf')); ?>" method="POST" style="display: none;" target="_blank">
                                <?php echo csrf_field(); ?>
                                <?php echo e(Form::hidden('directorio', base64_encode(serialize($directorio)))); ?>

                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datos" class="display table table-hover table-full-width" >
                            <thead>
                                <tr>
                                    <th class="text-center">Interno</th>
                                    <th class="text-center">Nombre</th>
                                    <th class="text-center">Unidad</th>
                                    <th class="text-center">Gerencia</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $directorio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-center"><strong><h2><?php echo e($d->interno); ?></h2></strong></td>
                                        <td class="text-left"> <div class="info-user ml-3">
                                            <h3 class="text-primary"><?php echo e($d->nombre); ?></h3>
                                            <div class="status"><?php echo e($d->cargo); ?></div>
                                        </div> </td>
                                        <td class="text-center"><?php echo e($d->unidad); ?></td>
                                        <td class="text-center"><?php echo e($d->area); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        
                    </div>
                </div>
            </div>
        </div>
            
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/js/tablas/basica.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('intranet.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/intranet/resources/views/intranet/directorio.blade.php ENDPATH**/ ?>