<div>
    <div class="row mb-0">
        <div class="col-md-4 mb-1 pl-0 pr-0">
            <div class="form-group pb-0 ">
                <i class="fas fa-filter mr-2"></i><label for="" class="mb-0">Tipo de Documento</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="tipoFiltro" class="form-control tipo_contenido">
                        <option value="">-- VER TODOS --</option>
                        <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($t->id); ?>"><?php echo e($t->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-1 pl-0 pr-0">
            <div class="form-group pb-0 pr-0">
                <i class="fas fa-filter mr-2"></i><label for="" class="mb-0">Grupo</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="grupoFiltro" class="form-control grupo_id">
                        <option value="" wire:click="borrar_unidad">-- VER TODOS --</option>
                        <?php $__currentLoopData = $grupos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grupo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($grupo->id); ?>"><?php echo e($grupo->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_unidad" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-1 pl-0 pr-0">
            <div class="form-group pb-0 pr-0">
                <i class="fas fa-filter mr-2"></i><label for="" class="mb-0">Unidad Institucional</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="unidadFiltro" class="form-control unidad_id" >
                        <option value="">-- VER TODOS --</option>
                        <?php $__currentLoopData = $unidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($unidad->id); ?>"><?php echo e($unidad->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_unidad" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        
    </div>
    <div class="row mb-3">
        <div class="col-md-3 mb-1 pl-0 pr-0">
            <div class="form-group pb-0 ">
                <i class="fas fa-filter mr-2"></i><label for="" class="mb-0">Visible</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="visibleFiltro" class="form-control ">
                        <option value="">-- VER TODOS --</option>
                        <option value="1">Para Todos</option>
                        <option value="false">Solo Para la Unidad</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-1 pl-0 pr-0">
            <div class="form-group pb-0 ">
                <i class="fas fa-filter mr-2"></i><label for="" class="mb-0">Estado</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="estadoFiltro" class="form-control ">
                        <option value="">-- VER TODOS --</option>
                        <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($e->id); ?>"><?php echo e($e->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-1 pl-0 pr-0">
            <div class="form-group pb-0 ">
                <i class="fas fa-filter mr-2"></i><label for="" class="mb-0">Estado Documento</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="estadoDocumentoFiltro" class="form-control ">
                        <option value="">-- VER TODOS --</option>
                        <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($estado->id); ?>"><?php echo e($estado->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-1 pl-0">
            <div class="form-group pb-0 pr-0">
                <i class="fas fa-search mr-2"></i><label for="" class="mb-0">Buscar</label>
                <div class="d-flex align-items-center justify-content-center">
                    <input type="text" wire:model="search" id="searchFilter" class="form-control" placeholder="Ingrese un texto.....">
                    <button class="btn btn-info btn-icon btn-sm" data-toggle="tooltip" wire:click="borrar_search" title="Borrar Contenido"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover table-sm datatable">
          <thead>
            <th class="text-center">Fecha</th>
            <th class="text-center">Nro. Resolución</th>
            <th class="text-center">Título</th>
            <th class="text-center">Tipo Documento</th>
            <th class="text-center">Grupo</th>
            <th class="text-center">Visible</th>
            <th class="text-center">Estado</th>
            <th class="text-center">Estado Documento</th>
            <th class="text-center">Acciones</th>
          </thead>
          <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $documentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td class="text-center"><?php echo e(date('d/m/Y',strtotime( $c->fecha))); ?></td>
                <td class="text-center"><?php echo e($c->nro_resolucion); ?></td>
                <td class="text-left">
                    <a href="<?php echo e(route('ver_adjuntos',$c->id)); ?>" title="Ver adjunto" data-toggle="tooltip" target="_blank"> <i class="fas fa-download mr-2"></i><strong>TITULO:</strong><?php echo e($c->titulo); ?> </a><br></a>
                    <?php if($c->descripcion!=null): ?> <strong>DESCRIPCION:</strong> <?php echo e($c->descripcion); ?><br> <?php endif; ?>
                    <?php if(auth()->user()->unidad_id == null): ?><span class="badge badge-gray"><?php echo e($c->unidad != null ? $c->unidad->nombre : 'SEDEM'); ?></span> <?php else: ?> <span class="badge badge-gray"><?php echo e($c->unidad->nombre); ?></span> <?php endif; ?>
                </td>
                <td class="text-center">
                    <?php echo e($c->tipo->nombre); ?>

                </td>
                <td class="text-center"><?php echo e($c->grupo->nombre); ?></td>
                <td class="text-center"><?php if($c->visible == 1): ?> <span class="badge badge-success">PARA TODOS</span> <?php else: ?> <span class="badge badge-secondary">SOLO UNIDAD</span> <?php endif; ?></td>
                <td class="text-center"><?php if($c->estado==0): ?> <span class="badge badge-danger">NO PUBLICADO</span> <?php else: ?> <span class="badge badge-success">PUBLICADO</span> <?php endif; ?></td>
                <td class="text-center"><?php if($c->estado_documento_id != null): ?> 
                    <?php switch($c->estado_documento->nombre):
                        case ('VIGENTE'): ?>
                            <span class="badge badge-success"><?php echo e($c->estado_documento->nombre); ?></span>
                            <?php break; ?>
                        <?php case ('NO VIGENTE'): ?>
                            <span class="badge badge-danger"><?php echo e($c->estado_documento->nombre); ?></span>
                            <?php break; ?>
                        <?php default: ?>
                            <?php echo e($c->estado_documento->nombre); ?>

                    <?php endswitch; ?>
                    <?php endif; ?>
                <td>
                    <button class="btn btn-default btn-round dropdown-toggle" type="button" data-toggle="dropdown"> 
                        OPCIONES
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <li>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('documentos_internos.edit')): ?>
                                <a class="dropdown-item" href="<?php echo e(route('documentos_internos.edit', $c)); ?>" data-toggle="tooltip" data-placement="bottom"  title="Editar datos del registro" href="#">Modificar Datos</a>
                                <?php if($c->estado==0): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('documentos_internos.publicar', $c)); ?>"  data-toggle="tooltip" data-placement="bottom" title="Publicar contenido" onclick="return confirm('¿Está seguro que desea PUBLICAR el DOCUMENTO INTERNO?');">Publicar</a>
                                <?php else: ?>
                                    <a class="dropdown-item" href="<?php echo e(route('documentos_internos.no_publicar', $c)); ?>" data-toggle="tooltip" data-placement="bottom" title="Dar de baja su publicación" onclick="return confirm('¿Está seguro que desea DAR DE BAJA la publicación del DOCUMENTO INTERNO?');">Dar de Baja</a>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('documentos_internos.destroy')): ?>
                                <form action="<?php echo e(route('documentos_internos.destroy', $c)); ?>" method="POST" style="display: inline-block;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="dropdown-item text-danger" data-toggle="tooltip" data-placement="bottom" title="Eliminar Registro" onclick="return confirm('¿Está seguro que desea ELIMINAR el DOCUMENTO INTERNO?');">Eliminar</button>
                                </form>
                            <?php endif; ?>
                        </li>
                        <li>
                            <button wire:click="abrirModalEstado(<?php echo e($c->id); ?>)" class="dropdown-item">
                                Cambiar Estado Documento
                            </button>
                        </li>
                    </ul>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="bg-warning-light text-center">
                <h3 class="pt-2 pb-2">No se encontraron resultados de acuerdo al filtro ingresado...</h3>
            </div>
            <?php endif; ?>
          </tbody>
        </table>
        <div class="d-flex justify-content-end"><?php echo e($documentos->links()); ?></div>
    </div>
    <?php if($showModal): ?>
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5);">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Cambiar Estado</h5>
                        <button type="button" wire:click="$set('showModal', false)" class="btn-close"><i class="fas fa-times"></i></button>
                    </div>
                    <div class="modal-body">
                        <label for="estado">Nuevo Estado:</label>
                        <select wire:model="estadoSeleccionado" class="form-control">
                            <option value="">Seleccione...</option>
                            <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($estado->id); ?>"><?php echo e($estado->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="button" wire:click="actualizarEstado" class="btn btn-primary">Guardar</button>
                        <button type="button" wire:click="$set('showModal', false)" class="btn btn-warning">Cancelar</button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function () {
        //Funciones que permiten controlar el cambio de los filtros y ejecutar la consulta correpondiente, siempre necesarios cuando se utiliza livewire
        window.initSelectFiltros=()=>{
            $('.unidad_id').select2();
            $('.tipo_contenido').select2();
            $('.grupo_id').select2();
        }
        initSelectFiltros();
        $('.tipo_contenido').on('change', function () {
            window.livewire.find('<?php echo e($_instance->id); ?>').set('tipoFiltro', $(this).val());
        });
        $('.unidad_id').on('change', function () {
            window.livewire.find('<?php echo e($_instance->id); ?>').set('unidadFiltro', $(this).val());
        });
        $('.grupo_id').on('change', function () {
            window.livewire.find('<?php echo e($_instance->id); ?>').set('grupoFiltro', $(this).val());
        });
        window.livewire.on('select2',()=>{
            initSelectFiltros();
        });
    });
</script>
<script>
    window.addEventListener('estado-actualizado', event => {
        Swal.fire({
            icon: 'success',
            title: '¡Estado actualizado!',
            text: 'El estado del documento ha sido cambiado exitosamente.',
            timer: 2500,
            showConfirmButton: false
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php /**PATH /var/www/html/intranet/resources/views/livewire/admin/admin-documento-interno-component.blade.php ENDPATH**/ ?>