

<?php $__env->startSection('titulo','Áreas'); ?>
<?php $__env->startSection('content'); ?>

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Áreas</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="<?php echo e(route('home')); ?>"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Áreas y Unidades</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Áreas</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Areas registrados hasta la fecha</h4>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('areas.create')): ?><a href="<?php echo e(route('areas.create')); ?>" class="btn btn-primary btn-round mr-2">Agregar Nueva Area</a><?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="table-responsive">
                                <table width="100%" id="datos" class="table table-hover table-sm">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Nombre Area</th>
                                            <th class="text-center">Nro de Unidades Dependientes</th>
                                            <th class="text-center"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($area->nombre); ?></td>
                                                <td class="text-center"><span class="badge badge-warning">Unidades: <strong><?php echo e($area->unidades->count()); ?></strong></span></td>
                                                <td class="text-center">
                                                    
                                                    <button class="btn btn-default btn-round dropdown-toggle" type="button" data-toggle="dropdown"> 
                                                    OPCIONES
                                                    </button>
                                                    <ul class="dropdown-menu" role="menu">
                                                        <li>
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('areas.edit')): ?>
                                                                <a class="dropdown-item" href="<?php echo e(route('areas.edit', $area)); ?>" href="#">Modificar Datos</a>
                                                                
                                                            <?php endif; ?>
                                                        </li>
                                                        <li>
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('areas.destroy')): ?>
                                                                <form action="<?php echo e(route('areas.destroy', $area)); ?>" method="POST" >
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <button type="submit" class="dropdown-item text-danger" onclick="return confirm('¿Está seguro que desea ELIMINAR EL AREA?');">Eliminar</button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
 <script src="<?php echo e(asset('assets/js/tablas/basica.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/intranet/resources/views/admin/areas/index.blade.php ENDPATH**/ ?>