
<?php $__env->startSection('titulo','Resultado busqueda'); ?>
<?php $__env->startSection('content'); ?>


<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Resultado de Búsqueda</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="<?php echo e(route('welcome')); ?>"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Resultado de Búsqueda</a></li>
        </ul>
      </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Resultados encontrados según el criterio de búsqueda palabra <strong>"<?php echo e($query); ?>"</strong></h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-sm" id="datos">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Sección</th>
                                            <th class="text-center">Fecha Publicación</th>
                                            <th class="text-center">Resolución</th>
                                            <th class="text-center">Titulo</th>
                                            <th class="text-center">Contenido</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $groupedResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section => $results): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th>
                                                <?php echo e($result['section']); ?>

                                            </th>
                                            <td class="text-center"><?php echo e(date('d/m/Y',strtotime($result['fecha']))); ?></td>
                                            <td><?php echo e($result['nro_resolucion']); ?></td>
                                            <td>
                                                <?php if($result['section']=='Capacitación'): ?>
                                                <a href="<?php echo e(route('ver_adjuntos', $result['id'])); ?>" target="_blank" class="btn btn-link btn-danger pb-0 pt-0"><i class="fas fa-video"></i> Ver</a>
                                                <?php else: ?>
                                                <a class="btn btn-link btn-danger pb-0 pt-0" href="<?php echo e($result['section']=='Noticias y Anuncios' ? route('noticia.publicada', $result['id']) : route('ver_adjuntos', $result['id'])); ?>" target="_blank"><i class="fas fa-file-pdf"></i> Ver</a>
                                                <?php endif; ?>
                                                <?php echo e($result['title']); ?>

                                            </td>
                                            <td><?php echo e($result['content']); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <h4>No existen registros que coincidan con la palabras ingresada...</h4>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                            
                                
                            
                        </div>
                    </div>                            
                </div>
            </div>
        </div>
    </div>
</div>
 <?php $__env->stopSection(); ?>
 <?php $__env->startSection('scripts'); ?>
 <script src="<?php echo e(asset('assets/js/tablas/basica.js')); ?>"></script>
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('intranet.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/intranet/resources/views/intranet/_resultado_busqueda.blade.php ENDPATH**/ ?>