<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use RealRashid\SweetAlert\Facades\Alert;
use Spatie\Permission\Models\Permission;

class RoleController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $roles=Role::where('id','>',1)->get();
        return view('admin.roles.index',compact('roles'));
    }

    public function create()
    {
        $permissions=Permission::all();
        $grupos=Permission::select('grupo')->orderBy('grupo','asc')->distinct()->get();
        $role= new Role();
        return view('admin.roles.create',compact('permissions','role','grupos'));
    }
    
    public function store(Request $request)
    {
        $permissions = $request->get('permissions', []);
        
        $role=Role::create(['name'=>$request->name,'descripcion'=>$request->descripcion]);
        $permissions = $request->get('permissions', []);
        // Verifica que no esté vacío y que contenga valores válidos
        $validPermissions = Permission::whereIn('id', $permissions)->pluck('name')->toArray();
        //actualice los permisos
        $role->syncPermissions($validPermissions);
        
        Alert::success('Rol registrado correctamente!');
        return redirect()->route('roles.index');
    }

    public function show(Role $role)
    {
        $permissions=$role->permissions;
        return view('admin.roles.show',compact('role','permissions'));
    }

    public function edit(Role $role)
    {
        $permissions=Permission::get();
        $grupos=Permission::select('grupo')->orderBy('grupo','asc')->distinct()->get();
        return view('admin.roles.edit',compact('role','permissions','grupos'));
    }
    public function update(Request $request, Role $role)
    {
        //actualice el rol
        $role->update($request->all());
        //actualice los permisos
        $role->permissions()->sync($request->get('permissions'));

        Alert::success('Rol actualizado correctamente!');
        return redirect()->route('roles.index');
    }

    public function destroy(Role $role)
    {
        // Obtener los usuarios que tenían este rol
        $usersWithRole = User::whereHas('roles', function ($query) use ($role) {
            $query->where('id', $role->id);
        })->get();

        // Eliminar el rol
        $role->delete();

        // Deshabilitar solo los usuarios que tenían ese rol (y ahora ya no tienen roles)
        $usersToDisable = $usersWithRole->filter(function ($user) {
            return $user->roles()->count() === 0;
        });

        foreach ($usersToDisable as $user) {
            $user->delete();
        }

        Alert::success('Rol eliminado correctamente y se deshabilitaron '.$usersToDisable->count().' usuarios asociados!');
        return redirect()->route('roles.index');
    }

}
