<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SsoAutenticacionSeguridadController extends Controller
{
    public function autenticacion(Request $request){
        //dd($request->all());
        try {
            // Captura el token desde la query string
            $token = $request->query('tt');
           
            // Dividir el token en sus tres partes
            list($header, $payload, $signature) = explode('.', $token);

            // Decodificar el payload (sin verificar la firma)
            $datos = json_decode(base64_decode($payload), true);
            
            $user = User::updateOrCreate(
                // Condición para encontrar al usuario
                ['username' => $datos['Loguin']],
                // Datos a actualizar o crear
                [
                    'name' => $datos['sub'],
                    'idsegUsuario' => $datos['uid'],
                    'idsegPerfil' => $datos['IdPerfil'],
                    'nombrePerfil' => $datos['Perfil'],
                    'password' => bcrypt('password_predeterminado'),
                ]
            );
            // Loguear al usuario
            session(['auth_token' => $user['jwToken']]);
            session(['idsegPerfil' => $user['idsegPerfil']]);
            
            $user->assignRole($datos['Perfil']);
            
            Auth::login($user);

            return redirect()->route('home')->with('success', 'Inicio de sesión exitoso');
        } catch (\Exception $e) {
            return response()->json(['error' => 'Token inválido o expirado', 'message' => $e->getMessage()], 400);
        }
    }    

    public function rol()
    {
        return $this->belongsToMany('Spatie\Permission\Models\Role', 'model_has_roles', 'model_id', 'role_id')->withPivot('role_id');
    }
}
