<?php

namespace App\Models;

use Carbon\Traits\Timestamp;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;

class Audiencia extends Model implements Auditable
{
    use SoftDeletes, Timestamp;
     use \OwenIt\Auditing\Auditable;

    protected $table = 'audiencias';

    protected $fillable = [
        'proceso_id',
        'departamento',
        'tipo_audiencia_id',
        'fecha_audiencia',
        'hora_audiencia',
        'lugar',
        'juzgado',
        'sala',
        'delito','estado_id',
        'representantes',
        'observaciones'
    ];

    protected $dates = ['fecha_audiencia'];

    public function abogado()
    {
        return $this->belongsTo(User::class, 'abogado_id');
    }

    public function tipo_audiencia()
    {
        return $this->belongsTo(Parametro::class, 'tipo_audiencia_id', 'id');
    }

    /* Semaforización */
    public function getColorAttribute()
    {
        if ($this->estado === 'CONCLUIDA') return '';

        $dias = now()->startOfDay()
            ->diffInDays($this->fecha_audiencia, false);

        if ($dias < 0 || $dias === 0) return 'danger';
        if ($dias <= 2) return 'warning';
        if ($dias <= 7) return 'success';

        return 'primary';
    }

    public function proceso()
    {
        return $this->belongsTo(Proceso::class);
    }

    public function estado()
    {
        return $this->belongsTo(Parametro::class, 'estado_id', 'id');
    }

    public function getAbogadosAttribute()
    {
        return User::whereIn('id',explode(';', $this->representantes))->get();
    }
}
